/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.calendars;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.core.observation.Event;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractCalendarEventActivityType
extends AbstractWorkspacesActivityType {
    public static final String ACTIVITY_CATEGORY_CALENDARS = "calendars";
    public static final String CALENDAR_EVENT_TITLE = "eventTitle";
    public static final String CALENDAR_EVENT_ID = "eventId";
    public static final String CALENDAR_TITLE = "calendarTitle";
    public static final String CALENDAR_ID = "calendarId";
    public static final String CALENDAR_EVENT_START_DATE = "eventStartDate";
    public static final String CALENDAR_EVENT_END_DATE = "eventEndDate";
    public static final String CALENDAR_EVENT_FULL_DATE = "eventFullDay";
    public static final String CALENDAR_EVENT_RECURRENCE = "eventRecurrence";
    public static final String CALENDAR_EVENT_REPEATER_UNTIL = "eventRepeatUntil";
    private CalendarWorkspaceModule _calendarModule;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._calendarModule = (CalendarWorkspaceModule)moduleManagerEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
    }

    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        activity.setValue("category", (Object)ACTIVITY_CATEGORY_CALENDARS);
        Calendar calendar = (Calendar)parameters.get("calendar");
        CalendarEvent calendarEvent = (CalendarEvent)parameters.get("calendar.event");
        activity.setValue(CALENDAR_TITLE, (Object)calendar.getName());
        activity.setValue(CALENDAR_ID, (Object)calendar.getId());
        activity.setValue(CALENDAR_EVENT_TITLE, (Object)calendarEvent.getTitle());
        activity.setValue(CALENDAR_EVENT_ID, (Object)calendarEvent.getId());
        activity.setValue(CALENDAR_EVENT_START_DATE, (Object)calendarEvent.getStartDate());
        activity.setValue(CALENDAR_EVENT_END_DATE, (Object)calendarEvent.getEndDate());
        activity.setValue(CALENDAR_EVENT_FULL_DATE, (Object)calendarEvent.getFullDay());
        activity.setValue(CALENDAR_EVENT_RECURRENCE, (Object)calendarEvent.getRecurrenceType().name().toUpperCase());
        if (!calendarEvent.getRecurrenceType().equals((Object)EventRecurrenceTypeEnum.NEVER) && calendarEvent.getRepeatUntil() != null) {
            activity.setValue(CALENDAR_EVENT_REPEATER_UNTIL, (Object)DateUtils.zonedDateTimeToString((ZonedDateTime)calendarEvent.getRepeatUntil()));
        }
    }

    @Override
    public Map<String, Object> additionnalDataToJSONForClient(Activity activity) {
        Map<String, Object> json = super.additionnalDataToJSONForClient(activity);
        String calendarId = (String)activity.getValue(CALENDAR_ID);
        String calendarEventId = (String)activity.getValue(CALENDAR_EVENT_ID);
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        if (project != null) {
            if (!"calendar.event.deleting".equals(activity.getEventType())) {
                json.put("eventUrl", this._calendarModule.getEventUri(project, calendarId, calendarEventId));
            } else {
                json.put("eventUrl", this._calendarModule.getModuleUrl(project));
            }
        }
        return json;
    }

    @Override
    public Expression getFilterPatternExpression(String pattern) {
        StringExpression eventExpr = new StringExpression(CALENDAR_EVENT_TITLE, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        StringExpression calExpr = new StringExpression(CALENDAR_TITLE, Expression.Operator.WD, pattern, ExpressionContext.newInstance().withCaseInsensitive(true));
        return new OrExpression(new Expression[]{eventExpr, calExpr});
    }

    @Override
    public boolean isMergeable(Activity activity1, Activity activity2) {
        if (!super.isMergeable(activity1, activity2)) {
            return false;
        }
        String calendarId1 = (String)activity1.getValue(CALENDAR_ID);
        String calendarId2 = (String)activity2.getValue(CALENDAR_ID);
        return calendarId1 != null && calendarId2 != null && calendarId1.equals(calendarId2);
    }

    public Map<String, Object> mergeActivities(List<Activity> activities) {
        Map mergedActivities = super.mergeActivities(activities);
        ArrayList mergedEvents = new ArrayList();
        ArrayList<String> knownEvents = new ArrayList<String>();
        for (Activity activity : activities) {
            HashMap<String, String> eventInfo = new HashMap<String, String>();
            String eventId = (String)activity.getValue(CALENDAR_EVENT_ID);
            if (knownEvents.contains(eventId)) continue;
            knownEvents.add(eventId);
            Map jsonActivity = activity.toJSONForClient();
            eventInfo.put(CALENDAR_EVENT_ID, eventId);
            eventInfo.put(CALENDAR_EVENT_TITLE, (String)jsonActivity.get(CALENDAR_EVENT_TITLE));
            eventInfo.put(CALENDAR_EVENT_START_DATE, (String)jsonActivity.get(CALENDAR_EVENT_START_DATE));
            eventInfo.put(CALENDAR_EVENT_END_DATE, (String)jsonActivity.get(CALENDAR_EVENT_END_DATE));
            eventInfo.put(CALENDAR_EVENT_FULL_DATE, (String)jsonActivity.get(CALENDAR_EVENT_FULL_DATE));
            eventInfo.put(CALENDAR_EVENT_RECURRENCE, (String)jsonActivity.get(CALENDAR_EVENT_RECURRENCE));
            eventInfo.put(CALENDAR_EVENT_REPEATER_UNTIL, (String)jsonActivity.get(CALENDAR_EVENT_REPEATER_UNTIL));
            mergedEvents.add(eventInfo);
        }
        mergedActivities.put("events", mergedEvents);
        mergedActivities.put("amount", mergedEvents.size());
        return mergedActivities;
    }

    @Override
    public Project getProjectFromEvent(Event event) {
        Map args = event.getArguments();
        Calendar calendar = (Calendar)args.get("calendar");
        return calendar.getProject();
    }

    public boolean isGenericCalendarEventActivityType() {
        return true;
    }
}

