/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.jcr;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.WorkflowAwareCalendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarFactory;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.model.ModelItemContainer;

public class JCRCalendar
extends DefaultTraversableAmetysObject<JCRCalendarFactory>
implements WorkflowAwareCalendar,
ModifiableExplorerNode,
ModifiableModelAwareDataAwareAmetysObject {
    public static final String APPLICATION_ID = "Ametys.plugins.explorer.applications.Calendar";
    public static final String CALENDAR_TITLE = "title";
    public static final String CALENDAR_DESC = "description";
    public static final String CALENDAR_COLOR = "color";
    public static final String CALENDAR_VISIBILITY = "visibility";
    public static final String CALENDAR_WORKFLOW_NAME = "workflowName";
    public static final String CALENDAR_TEMPLATE_DESC = "template-description";
    public static final String CALENDAR_ICS_TOKEN = "ics-token";

    public JCRCalendar(Node node, String parentPath, JCRCalendarFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    public String getIconCls() {
        return "calendar";
    }

    public String getApplicationId() {
        return APPLICATION_ID;
    }

    @Override
    public Project getProject() {
        return ((JCRCalendarFactory)this._getFactory()).getProjectManager().getParentProject((AmetysObject)this);
    }

    public String getExplorerPath() {
        AmetysObject parent = this.getParent();
        if (parent instanceof ExplorerNode) {
            return ((ExplorerNode)parent).getExplorerPath() + "/" + this.getName();
        }
        return "";
    }

    @Override
    public String getDescription() {
        return (String)this.getValue(CALENDAR_DESC);
    }

    @Override
    public String getColor() {
        return (String)this.getValue(CALENDAR_COLOR);
    }

    @Override
    public Calendar.CalendarVisibility getVisibility() {
        if (this.hasValue(CALENDAR_VISIBILITY)) {
            return Calendar.CalendarVisibility.valueOf((String)this.getValue(CALENDAR_VISIBILITY));
        }
        return Calendar.CalendarVisibility.PRIVATE;
    }

    @Override
    public String getWorkflowName() {
        return (String)this.getValue(CALENDAR_WORKFLOW_NAME);
    }

    @Override
    public String getTemplateDescription() {
        return (String)this.getValue(CALENDAR_TEMPLATE_DESC, false, "");
    }

    @Override
    public List<Calendar> getChildCalendars() {
        return this.getChildren().stream().filter(Calendar.class::isInstance).map(Calendar.class::cast).toList();
    }

    @Override
    public List<CalendarEvent> getAllEvents() {
        return this.getChildren().stream().filter(CalendarEvent.class::isInstance).map(CalendarEvent.class::cast).toList();
    }

    @Override
    public Map<CalendarEvent, List<CalendarEventOccurrence>> getEvents(ZonedDateTime startDate, ZonedDateTime endDate) {
        HashMap<CalendarEvent, List<CalendarEventOccurrence>> events = new HashMap<CalendarEvent, List<CalendarEventOccurrence>>();
        for (CalendarEvent event : this.getAllEvents()) {
            List<CalendarEventOccurrence> occurences = event.getOccurrences(startDate, endDate);
            if (occurences.isEmpty()) continue;
            events.put(event, occurences);
        }
        return events;
    }

    @Override
    public void setDescription(String desc) {
        this.setValue(CALENDAR_DESC, desc);
    }

    @Override
    public void setColor(String color) {
        this.setValue(CALENDAR_COLOR, color);
    }

    @Override
    public void setVisibility(Calendar.CalendarVisibility visibility) {
        this.setValue(CALENDAR_VISIBILITY, visibility.name());
    }

    @Override
    public void setWorkflowName(String workflowName) {
        this.setValue(CALENDAR_WORKFLOW_NAME, workflowName);
    }

    @Override
    public void setTemplateDescription(String templateDesc) {
        this.setValue(CALENDAR_TEMPLATE_DESC, templateDesc);
    }

    public boolean hasChildExplorerNodes() throws AmetysRepositoryException {
        try (AmetysObjectIterable children = this.getChildren();){
            for (AmetysObject child : children) {
                if (!(child instanceof ExplorerNode)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String getIcsUrlToken() {
        return (String)this.getValue(CALENDAR_ICS_TOKEN);
    }

    @Override
    public void setIcsUrlToken(String token) {
        if (token != null) {
            this.setValue(CALENDAR_ICS_TOKEN, token);
        } else {
            this.removeValue(CALENDAR_ICS_TOKEN);
        }
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((JCRCalendarFactory)this._getFactory()).getCalendarEventModel());
    }
}

