/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.mentions.AbstractNotifyMentionsObserver;
import org.ametys.cms.repository.mentions.MentionUtils;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.comments.AbstractNotifyWorkspacesCommentMentionsObserver;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;

public class NotifyFileCommentMentionsObserver
extends AbstractNotifyWorkspacesCommentMentionsObserver<File> {
    public boolean supports(Event event) {
        return event.getId().equals("resource.commented");
    }

    protected AbstractNotifyMentionsObserver.MentionableObject _getMentionableObjectFromArguments(Map<String, Object> arguments) throws Exception {
        File file = (File)((Object)this._getAmetysObjectFromArguments(arguments));
        String commentId = (String)arguments.get("fileCommentId");
        Comment comment = file.getComment(commentId);
        Project project = this._projectManager.getParentProject((AmetysObject)file);
        String url = this._getAbsoluteUrl(file, project);
        return new AbstractNotifyMentionsObserver.MentionableObject(this._userManager.getUser(comment.getAuthor()), comment.getContent(), (Collection)MentionUtils.extractMentionedUsersFromSimpleText((String)comment.getContent()), comment.getCreationDate(), (AmetysObject)file, new AbstractNotifyMentionsObserver.LinkToAmetysObject(url, new I18nizableText("plugin.workspaces", "PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT")), this._getLanguage(project));
    }

    protected String _getAmetysObjectTitle(File file) {
        return file.getName();
    }

    protected I18nizableText _getMailMessage(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        File file = (File)mentionableObject.ametysObject();
        Project project = this._projectManager.getParentProject((AmetysObject)file);
        User author = mentionableObject.author();
        List<String> i18nParams = List.of(author.getFullName(), this._getAmetysObjectTitle(file), project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_RESOURCE_MENTION_MAIL_MESSAGE", i18nParams);
    }

    @Override
    protected String _getModuleId() {
        return DocumentWorkspaceModule.DOCUMENT_MODULE_ID;
    }

    @Override
    protected String getUrl(File ametysObject, Project project) {
        return this._documentModule.getModuleUrl(project);
    }
}

