/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.authentication.AuthorizationRequiredException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class CheckReadAccessAction
extends org.ametys.cms.rights.CheckReadAccessAction {
    private static List<String> CHECK_PARENT_ACCESS_METHODS = Collections.unmodifiableList(Arrays.asList("PUT", "MKCOL"));

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String method = request.getMethod();
        UserIdentity user = this._currentUserProvider.getUser();
        AmetysObject ao = this.getAmetysObject(parameters, request);
        if (ao == null) {
            if (CHECK_PARENT_ACCESS_METHODS.contains(method)) {
                String path = parameters.getParameter("path");
                Project project = (Project)((Object)request.getAttribute("project"));
                ao = this._getFirstParent(project, path);
            } else {
                throw new ResourceNotFoundException("Resource not found for path " + parameters.getParameter("objectPath", ""));
            }
        }
        if (this._rightManager.hasAnonymousReadAccess((Object)ao)) {
            return EMPTY_MAP;
        }
        if (user == null) {
            throw new AuthorizationRequiredException();
        }
        if (this._rightManager.hasReadAccess(user, (Object)ao)) {
            return null;
        }
        throw new AccessDeniedException("Access to object " + ao.getId() + " is not allowed for user " + String.valueOf(user));
    }

    private AmetysObject _getFirstParent(Project project, String path) {
        ModifiableResourceCollection parent = (ModifiableResourceCollection)this._resolver.resolveByPath(project.getPath() + "/ametys-internal:resources/");
        for (String folder : path.split("/")) {
            if (folder.isEmpty()) continue;
            if (!parent.hasChild(folder)) {
                return parent;
            }
            parent = (ModifiableResourceCollection)parent.getChild(folder);
        }
        return null;
    }
}

