/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum.jcr;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.cms.repository.comment.AbstractComment;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DefaultModifiableModelLessDataHolder;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObjectHelper;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.ThreadCategoryEnum;
import org.ametys.plugins.workspaces.forum.jcr.JCRThreadFactory;
import org.ametys.runtime.model.ModelItemContainer;
import org.apache.commons.lang3.EnumUtils;

public class JCRThread
extends DefaultAmetysObject<JCRThreadFactory>
implements Thread {
    public JCRThread(Node node, String parentPath, JCRThreadFactory factory) {
        super(node, parentPath, (DefaultAmetysObjectFactory)factory);
    }

    @Override
    public String getTitle() {
        return (String)this.getValue("title");
    }

    @Override
    public void setTitle(String title) {
        this.setValue("title", title);
    }

    @Override
    public RichText getContent() {
        return (RichText)this.getValue("content");
    }

    @Override
    public void setContent(RichText richText) {
        this.setValue("content", richText);
    }

    @Override
    public UserIdentity getAuthor() {
        return (UserIdentity)this.getValue("author");
    }

    @Override
    public void setAuthor(UserIdentity author) {
        this.setValue("author", author);
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue("creationDate");
    }

    @Override
    public void setCreationDate(ZonedDateTime creationDate) {
        this.setValue("creationDate", creationDate);
    }

    @Override
    public ZonedDateTime getLastModified() {
        return (ZonedDateTime)this.getValue("lastModified");
    }

    @Override
    public void setLastModified(ZonedDateTime date) {
        this.setValue("lastModified", date);
    }

    @Override
    public ZonedDateTime getLastContribution() {
        return (ZonedDateTime)this.getValue("lastContribution");
    }

    @Override
    public void setLastContribution(ZonedDateTime date) {
        this.setValue("lastContribution", date);
    }

    public void tag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)tag);
    }

    public void untag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)tag);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this);
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((JCRThreadFactory)this._getFactory()).getThreadModel());
    }

    @Override
    public ThreadCategoryEnum getCategory() {
        String category = (String)this.getValue("category");
        if (EnumUtils.isValidEnum(ThreadCategoryEnum.class, (String)category)) {
            return ThreadCategoryEnum.valueOf(category);
        }
        return ThreadCategoryEnum.DISCUSSION;
    }

    @Override
    public void setCategory(ThreadCategoryEnum category) {
        this.setValue("category", category.name());
    }

    @Override
    public UserIdentity getCloseAuthor() {
        return this.hasValue("closeAuthor") ? (UserIdentity)this.getValue("closeAuthor") : null;
    }

    @Override
    public void setCloseAuthor(UserIdentity author) {
        this.setValue("closeAuthor", author);
    }

    @Override
    public ZonedDateTime getCloseDate() {
        return this.hasValue("closeDate") ? (ZonedDateTime)this.getValue("closeDate") : null;
    }

    @Override
    public void setCloseDate(ZonedDateTime date) {
        this.setValue("closeDate", date);
    }

    public List<Binary> getAttachments() {
        Binary[] attachements = (Binary[])this.getValue("attachments", false, new Binary[0]);
        return Arrays.asList(attachements);
    }

    public void setAttachments(List<Binary> attachments) {
        this.setValue("attachments", attachments.toArray(new Binary[attachments.size()]));
    }

    private ModifiableModelLessDataHolder _getCommentDataHolder() {
        try {
            Node baseNode = this.getBaseNode();
            if (!baseNode.hasNode("ametys:comments")) {
                baseNode.addNode("ametys:comments", "ametys:compositeMetadata");
            }
            baseNode.getSession().save();
            JCRRepositoryData repositoryData = new JCRRepositoryData(baseNode.getNode("ametys:comments"));
            return new DefaultModifiableModelLessDataHolder(((JCRThreadFactory)this._getFactory()).getUnversionedDataTypeExtensionPoint(), (ModifiableRepositoryData)repositoryData);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    public RichTextComment createComment() {
        return new RichTextComment(this._getCommentDataHolder());
    }

    public RichTextComment createComment(String commentId, ZonedDateTime creationDate) {
        return new RichTextComment(this._getCommentDataHolder(), commentId, creationDate);
    }

    public RichTextComment getComment(String commentId) throws AmetysRepositoryException {
        return RichTextComment.getComment((ModifiableModelLessDataHolder)this._getCommentDataHolder(), (String)commentId);
    }

    public List<RichTextComment> getComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        return RichTextComment.getComments((ModifiableModelLessDataHolder)this._getCommentDataHolder(), (boolean)includeNotValidatedComments, (boolean)includeValidatedComments);
    }

    @Override
    public RichTextComment getAcceptedAnswer() {
        if (this.getCategory() == ThreadCategoryEnum.DISCUSSION) {
            return null;
        }
        return this.getFlattenComments(true, true).stream().filter(AbstractComment::isAccepted).filter(Predicate.not(AbstractComment::isDeleted)).findFirst().orElse(null);
    }

    @Override
    public List<RichTextComment> getFlattenComments(boolean includeNotValidatedComments, boolean includeValidatedComments) throws AmetysRepositoryException {
        List<RichTextComment> flattenedComments = this._flattenComment(this.getComments(includeNotValidatedComments, includeValidatedComments)).stream().filter(subComment -> !subComment.isDeleted() || subComment.hasSubComments()).sorted((c1, c2) -> c1.getCreationDate().compareTo(c2.getCreationDate())).toList();
        return flattenedComments;
    }

    private List<RichTextComment> _flattenComment(List<RichTextComment> comments) {
        ArrayList<RichTextComment> flattenComments = new ArrayList<RichTextComment>();
        flattenComments.addAll(comments);
        for (RichTextComment comment : comments) {
            List subComments = comment.getSubComment(true, true);
            flattenComments.addAll(this._flattenComment(subComments));
        }
        return flattenComments;
    }
}

