/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.indexing.project;

import org.ametys.cms.indexing.explorer.AbstractSolrIndexResourceObserver;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.indexing.solr.SolrProjectResourceIndexer;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SolrIndexProjectResourceObserver
extends AbstractSolrIndexResourceObserver {
    protected SolrProjectResourceIndexer _solrProjectResourceIndexer;
    private Project _project;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._solrProjectResourceIndexer = (SolrProjectResourceIndexer)serviceManager.lookup(SolrProjectResourceIndexer.ROLE);
    }

    protected String[] getWorkspacesToIndex() {
        return new String[]{"default", "live"};
    }

    protected boolean isHandledResource(AmetysObject object) {
        for (AmetysObject current = object.getParent(); current != null; current = current.getParent()) {
            AmetysObject parent = current.getParent();
            if (!"documents".equals(current.getName()) || parent == null || !"ametys-internal:resources".equals(parent.getName()) || !(parent.getParent() instanceof Project)) continue;
            this._project = (Project)parent.getParent();
            return true;
        }
        return false;
    }

    protected void onResourceCreated(Resource resource, String workspaceName) throws Exception {
        if (this._project != null) {
            this._solrProjectResourceIndexer.indexProjectResource(resource, this._project, workspaceName);
            this._project = null;
        }
    }

    protected void onResourceUpdated(Resource resource, String workspaceName) throws Exception {
        if (this._project != null) {
            this._solrProjectResourceIndexer.indexProjectResource(resource, this._project, workspaceName);
            this._project = null;
        }
    }

    protected void onCollectionRenamedOrMoved(ResourceCollection resourceCollection, String workspaceName) throws Exception {
        if (this._project != null) {
            this._solrProjectResourceIndexer.indexProjectResources(resourceCollection, this._project, workspaceName);
            this._project = null;
        }
    }
}

