/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.indexing.solr;

import java.io.IOException;
import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.search.query.QuerySyntaxException;
import org.ametys.cms.search.solr.SolrClientProvider;
import org.ametys.plugins.workspaces.indexing.solr.SolrWorkspacesConstants;
import org.ametys.plugins.workspaces.search.query.ProjectQuery;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;

public class SolrProjectIndexer
extends AbstractLogEnabled
implements Component,
Serviceable,
SolrWorkspacesConstants {
    public static final String ROLE = SolrProjectIndexer.class.getName();
    protected SolrClientProvider _solrClientProvider;
    protected SolrIndexer _solrIndexer;

    public void service(ServiceManager manager) throws ServiceException {
        this._solrClientProvider = (SolrClientProvider)manager.lookup(SolrClientProvider.ROLE);
        this._solrIndexer = (SolrIndexer)manager.lookup(SolrIndexer.ROLE);
    }

    public void unindexProject(String projectId) throws SolrServerException, IOException, QuerySyntaxException {
        this.unindexProject(projectId, "default");
        this.unindexProject(projectId, "live");
    }

    public void unindexProject(String projectId, String workspaceName) throws SolrServerException, IOException, QuerySyntaxException {
        ProjectQuery query = new ProjectQuery(projectId);
        SolrClient solrClient = this._solrClientProvider.getUpdateClient(workspaceName);
        UpdateResponse solrResponse = solrClient.deleteByQuery(this._solrClientProvider.getCollectionName(workspaceName), query.build());
        int status = solrResponse.getStatus();
        if (status != 0) {
            throw new IOException("Ametys unindexing all Solr documents related to a Project- Expecting status code of '0' in the Solr response but got : '" + status + "'. Project id : " + projectId);
        }
        this.getLogger().debug("Successful unindexing of all Solr documents with field {} equals to {} in workspace {}", new Object[]{"workspace-projectId", projectId, workspaceName});
    }
}

