/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.members;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.NodeTypeHelper;
import org.ametys.plugins.repository.query.SortCriteria;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class MembersWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String MEMBERS_MODULE_ID = MembersWorkspaceModule.class.getName();
    public static final String MEMBERS_SERVICE_ID = "org.ametys.plugins.workspaces.module.Members";
    private static final String __WORKSPACES_MEMBERS_NODE_NAME = "members";
    private static final String __INVITATIONS_NODE_NAME = "ametys-internal:invitations";
    private static final String __INVITATION_NODE_NAME = "ametys:invitation";
    private static final String __NODETYPE_INVITATIONS = "ametys:invitations";
    private static final String __NODETYPE_INVITATION = "ametys:invitation";
    private static final String __MEMBER_NUMBER_HEADER_ID = "members$member_number";
    private static final String __INVITATION_DATE = "ametys:date";
    private static final String __INVITATION_MAIL = "ametys:mail";
    private static final String __INVITATION_AUTHOR = "ametys:author";
    private static final String __INVITATION_ACL = "ametys-internal:temp-acl";
    private WorkspaceModuleExtensionPoint _moduleEP;
    private Repository _repository;
    private ProjectMemberManager _projectMemberManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._repository = (Repository)smanager.lookup("javax.jcr.Repository");
        this._projectMemberManager = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
    }

    @Override
    public String getId() {
        return MEMBERS_MODULE_ID;
    }

    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_MEMBERS_NODE_NAME;
    }

    @Override
    protected String getModulePageName() {
        return __WORKSPACES_MEMBERS_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_MEMBERS_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_MEMBERS_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_MEMBERS_TITLE");
    }

    @Override
    protected void initializeModulePage(ModifiablePage memberPage) {
        ModifiableZone defaultZone = memberPage.createZone("default");
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
        defaultZoneItem.setServiceId(MEMBERS_SERVICE_ID);
        ModifiableModelAwareDataHolder params = defaultZoneItem.getServiceParameters();
        params.setValue("header", (Object)this._i18nUtils.translate((I18nizable)this.getModulePageTitle(), memberPage.getSitemapName()));
        params.setValue("xslt", (Object)this._getDefaultXslt(MEMBERS_SERVICE_ID));
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"member.added");
    }

    public Node getInvitationsRootNode(Project project, boolean create) throws RepositoryException {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        Node moduleNode = ((JCRResourcesCollection)moduleRoot).getNode();
        Node node = null;
        if (moduleNode.hasNode(__INVITATIONS_NODE_NAME)) {
            node = moduleNode.getNode(__INVITATIONS_NODE_NAME);
        } else if (create) {
            node = moduleNode.addNode(__INVITATIONS_NODE_NAME, __NODETYPE_INVITATIONS);
            moduleNode.getSession().save();
        }
        return node;
    }

    public List<Invitation> getInvitations(String email) {
        Session session = null;
        try {
            session = this._repository.login();
            StringExpression expr = new StringExpression("mail", Expression.Operator.EQ, email);
            String xPathQuery = this.getInvitationXPathQuery(null, (Expression)expr, null);
            Query query = session.getWorkspace().getQueryManager().createQuery(xPathQuery, "xpath");
            NodeIterator nodes = query.execute().getNodes();
            ArrayList<Invitation> invitations = new ArrayList<Invitation>();
            while (nodes.hasNext()) {
                Node node = (Node)nodes.next();
                invitations.add(this._getInvitation(node));
            }
            return invitations;
        }
        catch (RepositoryException ex) {
            if (session != null) {
                session.logout();
            }
            throw new AmetysRepositoryException("An error occurred executing the JCR query to get invitations for email " + email, (Throwable)ex);
        }
    }

    public List<Invitation> getInvitations(Project project) throws RepositoryException {
        ArrayList<Invitation> invitations = new ArrayList<Invitation>();
        SortCriteria sortCriteria = new SortCriteria();
        sortCriteria.addJCRPropertyCriterion(__INVITATION_DATE, false, false);
        String xPathQuery = this.getInvitationXPathQuery(project, null, sortCriteria);
        Query query = project.getNode().getSession().getWorkspace().getQueryManager().createQuery(xPathQuery, "xpath");
        NodeIterator nodes = query.execute().getNodes();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            invitations.add(this._getInvitation(node));
        }
        return invitations;
    }

    private Invitation _getInvitation(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        String email = node.getProperty(__INVITATION_MAIL).getString();
        Date date = node.getProperty(__INVITATION_DATE).getDate().getTime();
        Node authorNode = node.getNode(__INVITATION_AUTHOR);
        UserIdentity author = new UserIdentity(authorNode.getProperty("ametys:login").getString(), authorNode.getProperty("ametys:population").getString());
        HashMap<String, String> allowedProfileByModules = new HashMap<String, String>();
        Node aclNode = node.getNode(__INVITATION_ACL);
        NodeIterator children = aclNode.getNodes();
        while (children.hasNext()) {
            String moduleName;
            WorkspaceModule module;
            Value[] values;
            Node child = (Node)children.next();
            if (!child.hasProperty("ametys:allowed-profiles") || (values = child.getProperty("ametys:allowed-profiles").getValues()).length <= 0 || (module = this._moduleEP.getModuleByName(moduleName = child.getName())) == null) continue;
            allowedProfileByModules.put(module.getId(), values[0].getString());
        }
        return new Invitation(this, email, date, author, allowedProfileByModules, this._getProjectName(node));
    }

    private String _getProjectName(Node node) {
        try {
            Node parentNode;
            for (parentNode = node.getParent(); parentNode != null && !NodeTypeHelper.isNodeType((Node)parentNode, (String)"ametys:project"); parentNode = parentNode.getParent()) {
            }
            return parentNode != null ? parentNode.getName() : null;
        }
        catch (RepositoryException e) {
            this.getLogger().error("Unable to get parent project", (Throwable)e);
            return null;
        }
    }

    public String getInvitationXPathQuery(Project project, Expression invitExpression, SortCriteria sortCriteria) throws RepositoryException {
        String predicats = null;
        if (invitExpression != null) {
            predicats = StringUtils.trimToNull((String)invitExpression.build());
        }
        StringBuilder xpathQuery = new StringBuilder();
        if (project != null) {
            xpathQuery.append("/jcr:root").append(this.getInvitationsRootNode(project, true).getPath());
        }
        xpathQuery.append("//element(*, ametys:invitation)");
        if (predicats != null) {
            xpathQuery.append("[" + predicats + "]");
        }
        if (sortCriteria != null) {
            xpathQuery.append(" " + sortCriteria.build());
        }
        return xpathQuery.toString();
    }

    public Invitation addInvitation(Project project, Date invitDate, String mail, UserIdentity author, Map<String, String> allowedProfileByModules) throws RepositoryException {
        Node contextNode = this.getInvitationsRootNode(project, true);
        Node invitNode = contextNode.addNode("ametys:invitation", "ametys:invitation");
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(invitDate);
        invitNode.setProperty(__INVITATION_DATE, (Calendar)gc);
        invitNode.setProperty(__INVITATION_MAIL, mail);
        Node authorNode = invitNode.addNode(__INVITATION_AUTHOR);
        authorNode.setProperty("ametys:login", author.getLogin());
        authorNode.setProperty("ametys:population", author.getPopulationId());
        Node aclNode = invitNode.addNode(__INVITATION_ACL);
        for (Map.Entry<String, String> allowedProfile : allowedProfileByModules.entrySet()) {
            String moduleId = allowedProfile.getKey();
            String profileId = allowedProfile.getValue();
            WorkspaceModule module = (WorkspaceModule)this._moduleEP.getExtension(moduleId);
            if (module == null) continue;
            Node moduleNode = aclNode.addNode(module.getModuleName());
            moduleNode.setProperty("ametys:allowed-profiles", new String[]{profileId});
        }
        return new Invitation(this, mail, invitDate, author, allowedProfileByModules, project.getName());
    }

    public boolean invitationExists(Project project, String mail) throws RepositoryException {
        Node contextNode = this.getInvitationsRootNode(project, true);
        NodeIterator nodes = contextNode.getNodes("ametys:invitation");
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            if (!node.hasProperty(__INVITATION_MAIL) || !node.getProperty(__INVITATION_MAIL).getString().equals(mail)) continue;
            return true;
        }
        return false;
    }

    public boolean removeInvitation(Project project, String mail) throws RepositoryException {
        Node contextNode = this.getInvitationsRootNode(project, true);
        NodeIterator nodes = contextNode.getNodes("ametys:invitation");
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            if (!node.hasProperty(__INVITATION_MAIL) || !node.getProperty(__INVITATION_MAIL).getString().equals(mail)) continue;
            node.remove();
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, true, null);
            if (projectMembers != null) {
                return Map.of(__MEMBER_NUMBER_HEADER_ID, projectMembers.size());
            }
            return Map.of(__MEMBER_NUMBER_HEADER_ID, __SIZE_ERROR);
        }
        return Map.of(__MEMBER_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__MEMBER_NUMBER_HEADER_ID, new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_MEMBERS")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected boolean _showActivatedStatus() {
        return false;
    }

    @Override
    public Set<String> getAllEventTypes() {
        return Set.of("member.added", "member.deleted");
    }

    public class Invitation {
        private Date _date;
        private UserIdentity _author;
        private String _email;
        private Map<String, String> _allowedProfileByModules;
        private String _projectName;

        public Invitation(MembersWorkspaceModule this$0, String email, Date date, UserIdentity author, Map<String, String> allowedProfileByModules, String projectName) {
            this._email = email;
            this._date = date;
            this._author = author;
            this._allowedProfileByModules = allowedProfileByModules;
            this._projectName = projectName;
        }

        public String getEmail() {
            return this._email;
        }

        public Date getDate() {
            return this._date;
        }

        public UserIdentity getAuthor() {
            return this._author;
        }

        public Map<String, String> getAllowedProfileByModules() {
            return this._allowedProfileByModules;
        }

        public String getProjectName() {
            return this._projectName;
        }

        public String toString() {
            return "Invitation [mail=" + this._email + ", project=" + this._projectName + "]";
        }
    }
}

