/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractMailNotifierGenerator
extends ServiceableGenerator {
    public static final String ROOT_ELEMENT = "notification";
    protected WorkspaceModuleExtensionPoint _moduleManagerEP;
    protected ProjectManager _projectManager;
    protected RenderingContextHandler _renderingContextHandler;
    protected UserHelper _userHelper;
    protected UserManager _userManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)smanager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)smanager.lookup(RenderingContextHandler.ROLE);
        this._userHelper = (UserHelper)smanager.lookup(UserHelper.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        Map parentContextAttr = (Map)this.objectModel.get("parent-context");
        Activity activity = (Activity)parentContextAttr.get("activity");
        String eventId = activity.getEventType();
        UserIdentity issuerIdentity = activity.getAuthor();
        Project project = this._projectManager.getProject((String)activity.getValue("projectName"));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)ROOT_ELEMENT);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"eventKey", (String)this.getEventIdAsI18nKey(eventId));
        this.saxProject(project);
        Page modulePage = this.getModulePage(project);
        if (modulePage != null) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"modulePageId", (String)modulePage.getId());
        }
        this._saxProjectUserIdentity(issuerIdentity, project, "issuer");
        activity.toSAX(this.contentHandler);
        this.saxAdditionalData(activity);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)ROOT_ELEMENT);
        this.contentHandler.endDocument();
    }

    protected void saxAdditionalData(Activity activity) throws SAXException {
    }

    protected void _saxProjectUserIdentity(UserIdentity issuerIdentity, Project project, String tagname) throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)tagname);
        this._userHelper.saxUserIdentity(issuerIdentity, this.contentHandler);
        if (ArrayUtils.contains((Object[])project.getManagers(), (Object)issuerIdentity)) {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"manager", (String)"true");
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"manager", (String)"false");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)tagname);
    }

    protected void saxProject(Project project) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", project.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attr);
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"name", (String)project.getName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)project.getTitle());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)StringUtils.defaultString((String)project.getDescription()));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"managers", (String)this.getProjectManagersNames(project));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"url", (String)this.getProjectUrl(project));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
    }

    protected String getProjectManagersNames(Project project) {
        return Arrays.stream(project.getManagers()).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(User::getFullName).collect(Collectors.joining(", "));
    }

    protected abstract String _getModuleId();

    protected Page getModulePage(Project project) {
        String moduleId = this._getModuleId();
        Set<Page> pages = null;
        Object module = this._moduleManagerEP.getModule(moduleId);
        if (module != null && this._projectManager.isModuleActivated(project, moduleId)) {
            pages = this._projectManager.getModulePages(project, (WorkspaceModule)module);
        }
        if (pages != null && pages.size() > 0) {
            return (Page)pages.iterator().next();
        }
        return null;
    }

    protected String getProjectUrl(Project project) {
        return this._projectManager.getProjectUrl(project, "");
    }

    protected String getEventIdAsI18nKey(String eventId) {
        return eventId.toUpperCase().replace(".", "_");
    }
}

