/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.project.notification.AbstractMemberMailNotifierObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RemoveMemberMailNotifierObserver
extends AbstractMemberMailNotifierObserver {
    public boolean supports(Event event) {
        if ("member.deleted".equals(event.getId())) {
            return (Boolean)Config.getInstance().getValue("workspaces.member.removed.send.notification", true, (Object)false);
        }
        return false;
    }

    @Override
    protected I18nizableText getI18nSubject(Event event, Project project) {
        return new I18nizableText("plugin." + this._pluginName, "PROJECT_MAIL_NOTIFICATION_EVENT_SUBJECT_MEMBER_DELETED", List.of(project.getTitle()));
    }

    @Override
    protected String getMailBodyURI(Event event, Project project) {
        return "cocoon://_plugins/workspaces/notification-mail-member-event";
    }

    @Override
    protected Map<String, List<String>> getUserToNotifyByLanguage(Event event, Project project) {
        Group group;
        GroupIdentity groupIdentity;
        Map args = event.getArguments();
        String identity = (String)args.get("project.member.identity");
        JCRProjectMember.MemberType identityType = (JCRProjectMember.MemberType)((Object)args.get("project.member.identity.type"));
        if (JCRProjectMember.MemberType.USER == identityType) {
            return Optional.of(identity).map(UserIdentity::stringToUserIdentity).filter(userIdentity -> !this._projectMemberManager.isProjectMember(project, (UserIdentity)userIdentity)).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).map(p -> Map.of(StringUtils.defaultString((String)((User)p.getLeft()).getLanguage()), List.of((String)p.getRight()))).orElse(Map.of());
        }
        if (JCRProjectMember.MemberType.GROUP == identityType && (groupIdentity = GroupIdentity.stringToGroupIdentity((String)identity)) != null && (group = this._groupManager.getGroup(groupIdentity)) != null) {
            return group.getUsers().stream().filter(u -> !this._projectMemberManager.isProjectMember(project, (UserIdentity)u)).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).map(user -> Pair.of((Object)user, (Object)user.getEmail())).filter(p -> StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getRight()))).collect(Collectors.groupingBy(p -> StringUtils.defaultString((String)((User)p.getLeft()).getLanguage()), Collectors.mapping(Pair::getRight, Collectors.toList())));
        }
        return Map.of();
    }
}

