/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentFunction;
import org.ametys.core.observation.Event;
import org.ametys.plugins.workflow.EnhancedFunction;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SetNotifiedFunction
extends AbstractContentFunction {
    public static final String NOTIFIED_PROPERTY_NAME = "notified";
    protected ContentTypesHelper _cTypeHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cTypeHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        WorkflowAwareContent content = this.getContent(transientVars);
        if (this._cTypeHelper.isInstanceOf((Content)content, "org.ametys.plugins.workspaces.Content.projectNews")) {
            try {
                this._markAsNotified(content, transientVars);
                this._createVersion(content);
                this._addLabel(content, "Live");
                this._notifyObservers(content, transientVars);
            }
            catch (RepositoryException e) {
                throw new WorkflowException("Unable to set notified markup", (Throwable)e);
            }
        }
    }

    protected void _markAsNotified(WorkflowAwareContent content, Map transientVars) {
        if (content != null) {
            content.getInternalDataHolder().setValue(NOTIFIED_PROPERTY_NAME, (Object)true);
            content.saveChanges();
        }
    }

    protected void _notifyObservers(WorkflowAwareContent content, Map transientVars) throws WorkflowException {
        if (content != null) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            eventParams.put("content", content);
            eventParams.put("content.id", content.getId());
            this._observationManager.notify(new Event("project.news.published", this.getUser(transientVars), eventParams));
            this._observationManager.notify(new Event("content.validated", this.getUser(transientVars), eventParams));
        }
    }

    public EnhancedFunction.FunctionType getFunctionExecType() {
        return EnhancedFunction.FunctionType.POST;
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_SET_NOTIFIED_FUNCTION_LABEL");
    }
}

