/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification.preferences;

import java.util.Collection;
import java.util.Map;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ProjectDeletedObserver
implements AsyncObserver,
Serviceable {
    private NotificationPreferencesHelper _notificationPreferenceHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._notificationPreferenceHelper = (NotificationPreferencesHelper)((Object)manager.lookup(NotificationPreferencesHelper.ROLE));
    }

    public boolean supports(Event event) {
        return "project.deleted".equals(event.getId());
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        String projectName = (String)event.getArguments().get("project.name");
        Collection projectMembers = (Collection)event.getArguments().get("project.members");
        for (ProjectMemberManager.ProjectMember projectMember : projectMembers) {
            if (projectMember.getType() != JCRProjectMember.MemberType.USER) continue;
            this._notificationPreferenceHelper.deleteProjectNotificationPreferences(projectMember.getUser().getIdentity(), projectName);
        }
    }
}

