/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractSearchModuleGenerator;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public abstract class AbstractXpathSearchModuleGenerator
extends AbstractSearchModuleGenerator {
    @Override
    protected void saxHits(String siteName, String lang, String textfield, Request request, int offset, int limit, int minLimit) throws SAXException, ProcessingException {
        try {
            String query = this.getXPathQuery(siteName, lang, textfield, request, offset, limit);
            if (StringUtils.isNotEmpty((CharSequence)query)) {
                AmetysObjectIterable searchResults = this._resolver.query(query);
                long totalCount = searchResults.getSize();
                List results = searchResults.stream().skip(offset).limit(limit).collect(Collectors.toList());
                this.saxHits(results, lang, offset, limit, minLimit, totalCount);
            } else {
                this.saxHits(Collections.EMPTY_LIST, lang, offset, limit, minLimit, 0L);
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to get search results", (Throwable)e);
        }
    }

    protected String getProjectXPathQuery(List<Project> projects) {
        List projectNames = projects.stream().map(SimpleAmetysObject::getName).map(name -> "fn:name() = '" + name + "'").collect(Collectors.toList());
        return "//element(*, ametys:project)" + (String)(!projectNames.isEmpty() ? "[" + String.join((CharSequence)Expression.LogicalOperator.OR.toString(), projectNames) + "]" : "");
    }

    protected abstract String getXPathQuery(String var1, String var2, String var3, Request var4, int var5, int var6) throws Exception;
}

