/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.module;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.AndQuery;
import org.ametys.cms.search.query.ContentLanguageQuery;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.query.TagQuery;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.module.AbstractContentSolrSearchModuleGenerator;
import org.ametys.web.repository.content.WebContent;
import org.ametys.web.search.query.SiteQuery;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class NewsSearchModuleGenerator
extends AbstractContentSolrSearchModuleGenerator {
    private ContentTypesHelper _ctypeHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._ctypeHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
    }

    @Override
    protected ContentSearcherFactory.SimpleContentSearcher getSearcher() {
        return this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectNews", "org.ametys.plugins.workspaces.Content.catalogNews"});
    }

    @Override
    protected String getSortFieldName() {
        return "lastModified";
    }

    @Override
    protected SortOrder getSortOrder() {
        return SortOrder.DESC;
    }

    @Override
    protected Query getQuery(String siteName, String lang, String textfield, Request request) {
        HashSet<Object> queries = new HashSet<Object>();
        if (StringUtils.isNotBlank((CharSequence)textfield)) {
            StringQuery titleQuery = new StringQuery("title", Query.Operator.SEARCH, textfield.trim(), lang);
            FullTextQuery fullTextQuery = new FullTextQuery(textfield.trim(), "full", lang, Query.Operator.SEARCH);
            queries.add(new OrQuery(new Query[]{titleQuery, fullTextQuery}));
        }
        List<Project> projects = this.getProjects(request, true);
        Query projectNewsQuery = this.getProjectNewsQuery(request, lang, projects);
        boolean noProjectSelected = StringUtils.isBlank((CharSequence)request.getParameter("project"));
        if (noProjectSelected) {
            Query catalogNewsQuery = this.getCatalogNewsQuery(request, siteName);
            queries.add(new OrQuery(new Query[]{projectNewsQuery, catalogNewsQuery}));
        } else {
            queries.add(projectNewsQuery);
        }
        return new AndQuery(queries);
    }

    protected Query getProjectNewsQuery(Request request, String lang, List<Project> projects) {
        ContentTypeQuery projectNewsTypeQuery = new ContentTypeQuery(Query.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.projectNews"});
        Query projectSiteQuery = this.getSiteQuery(projects);
        ContentLanguageQuery langQuery = new ContentLanguageQuery(lang);
        return new AndQuery(new Query[]{projectNewsTypeQuery, projectSiteQuery, langQuery});
    }

    protected Query getCatalogNewsQuery(Request request, String siteName) {
        HashSet<Object> queries = new HashSet<Object>();
        queries.add(new ContentTypeQuery(Query.Operator.EQ, new String[]{"org.ametys.plugins.workspaces.Content.catalogNews"}));
        queries.add(new SiteQuery(new String[]{siteName}));
        Set<String> categories = this.getCategories(request);
        if (categories != null && !categories.isEmpty()) {
            List<String> tagCategories = categories.stream().map(c -> "WORKSPACES_CATEGORY_" + c).collect(Collectors.toList());
            queries.add(new TagQuery(tagCategories.toArray(new String[tagCategories.size()])));
        }
        return new AndQuery(queries);
    }

    @Override
    protected void saxAdditionalInformation(Content content) throws SAXException {
        super.saxAdditionalInformation(content);
        if (this._ctypeHelper.isInstanceOf(content, "org.ametys.plugins.workspaces.Content.projectNews")) {
            String siteName = ((WebContent)content).getSiteName();
            Project project = this._projectManager.getProject(siteName);
            if (project != null) {
                this.saxProject(project);
            }
        } else {
            this.saxCategory(content);
        }
    }

    protected void saxCategory(Content content) throws SAXException {
        Set tags = content.getTags();
        for (String tagName : tags) {
            Category category = (Category)this._categoryProviderEP.getTag(tagName, null);
            this.saxCategory(category);
        }
    }
}

