/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let projectManager = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.project.ProjectManager.ROLE);
let workspaceTaskDAO = Ametys.serviceManager.lookup(org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO.ROLE);
let userManager = Ametys.serviceManager.lookup(org.ametys.core.user.UserManager.ROLE);
let populationContextHelper = Ametys.serviceManager.lookup(org.ametys.core.user.population.PopulationContextHelper.ROLE);
const Arrays = Java.type("java.util.Arrays");
const UserIdentity = Java.type('org.ametys.core.user.UserIdentity');

let countProjects = 0;
let error = "";
projectManager.getProjects().forEach(function (project) 
{
    let site = project.getSite();
    let siteName = site.getName();
    
    let userPopulationsOnSite = populationContextHelper.getUserPopulationsOnContexts(Arrays.asList("/sites/" + siteName, "/sites-fo/" + siteName), false, false);

    let tasks = workspaceTaskDAO.getProjectTasks(project)
    for (let task of tasks)
    {
        let comments = task.getComments(true, true);
        for (let comment of comments)
        {
            let subcomments = comment.getSubComment(true, true);
            for (let subcomment of subcomments)
            {
               migrateComment(userPopulationsOnSite, subcomment);
            }
            
            migrateComment(userPopulationsOnSite, comment);
        }
        task.saveChanges();
    }
});


function migrateComment(userPopulationsOnSite, comment) 
{
    try
    {
        let author = userManager.getUserByEmail(userPopulationsOnSite, comment.getAuthorEmail());
        if (author != null)
        {
            comment.setAuthorURL(null);
            comment.setAuthor(author.getIdentity());
        }
    }
  
    catch (NotUniqueUserException)
    {
        const urlArray = comment.getAuthorURL().split('/');
        
        let user = urlArray[urlArray.length -2];
        let population = urlArray[urlArray.length -3];
        
        let authorByParsing = new UserIdentity(user, population);
        if (userManager.getUser(authorByParsing) != null)
        {
            comment.setAuthorURL(null);
            comment.setAuthor(authorByParsing);
        }
        else
        {
            logger.warn("Not unique user for email " + comment.getAuthorEmail())
        }
      
    }
}
