<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:ametys="org.ametys.core.util.AmetysXSLTHelper"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
                
    <xsl:template match="/">
        <css>
            .project-categories-tooltip-default
            <xsl:for-each select="/colors/color">
                 , .project-categories-tooltip-<xsl:value-of select="@id"/>
            </xsl:for-each>
            {
                    width: 12px;
				    height: 12px;
				    border-radius: 50%;
				    position: absolute;
				    margin-left: 4px;
                    margin-top: 3px;
            }

            .project-categories-default:after
            <xsl:for-each select="/colors/color">
                 , .project-categories-<xsl:value-of select="@id"/>:after
            </xsl:for-each>
            {
                    content: " ";
                    position: absolute;
                    width: 8px;
				    height: 8px;
				    border-radius: 50%;
				    border: 2px solid #fff;
				    left: 8px !important;
            }

            <xsl:for-each select="/colors/color[@id = /colors/@default]">
	             .project-categories-tooltip-default,
	             .project-categories-default:after {
                    background-color: <xsl:value-of select="main"/>;
                }
            </xsl:for-each>
            <xsl:for-each select="/colors/color">
                 .project-categories-tooltip-<xsl:value-of select="@id"/>,
                 .project-categories-<xsl:value-of select="@id"/>:after {
				    background-color: <xsl:value-of select="main"/>;
			    }
            </xsl:for-each>
        </css>
    </xsl:template>
</xsl:stylesheet>