<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:math="java.lang.Math"
                extension-element-prefixes="ametys math resolver">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="refreshDelay" select="ametys:serviceParameter('refreshDelay')/text()"/>
    <xsl:variable name="maxResults" select="ametys:serviceParameter('nbResultsPerPage')/text()"/>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">activity-stream</xsl:variable>
    <xsl:variable name="common-service-name">service-activity-stream</xsl:variable>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="moment-date-js"/>
        <xsl:call-template name="activity-stream-js"/>
        
        <script type="text/javascript">
            $j(document).ready(function(){
                // Active ping for getting new events
                ActivityStream.getNumberOfUnreadEvents();
            
                ActivityStream.open("#activity-stream-<xsl:value-of select="$uniqueId"/>", function() {
                    // handle show more links
                    $('.ametys-notifications__list .ametys-sidebar-voir').on('click', function () {
                        $(this).addClass('d-none');
                        $(this).parent().find('.ametys-q-panel__list_subtxt--limit').addClass('show');
                        $(this).parent().find('.ametys-q-panel__list_subtxt--limit li').removeAttr("aria-hidden");
                    });  
                });
                
                // Activity stream is always visible
                AmetysFront.Event.fire("activity-stream-opened");
                
                // Hide unread indicators after 1 min after update
                AmetysFront.Event.listen("activity-stream-uptodate", function(data) {
                    setTimeout(function() {
                        $j("#activity-stream-<xsl:value-of select="$uniqueId"/> .ametys-notifications__list_item .ametys-indicator").hide();
                    }, 60 * 1000)
                });
            });
        </script>
    </xsl:template>
    
    <xsl:template name="moment-date-js">
        <script src="{ametys:pluginResourceURL('workspaces', 'js/vendor/moment/moment-with-locales.min.js')}"></script>
        
        <script type="text/javascript">
            moment.locale('<xsl:value-of select="$lang"/>');
        </script>
    </xsl:template>
    
    <xsl:template name="activity-stream-js">    
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', 'js/workspaces/applicationv2/WorkspacesI18n.js')}"/>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/WorkspacesUtils.', ametys:lang(), '.js'))}"></script>
        <script type="text/javascript" src="{ametys:pluginResourceURL('workspaces', concat('js/activity-stream.', ametys:lang(), '.js'))}"></script>
        
        <script type="text/javascript">
            <!-- For legacy purpose (4.7 compatibility)-->
            window.VEvent = AmetysFront.Event
            <!-- // END for legacy purpose -->
            ActivityStream.configure('<xsl:value-of select="$site-uri-prefix"/>', '<xsl:value-of select="$site" />', '<xsl:value-of select="$lang" />', <xsl:value-of select="$refreshDelay"/>, <xsl:value-of select="$maxResults"/>);
        </script>
    </xsl:template>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<div id="activity-stream-{$uniqueId}"> 
            <div data-ametys-activitystream-role="results" >
                <!-- Activity stream will be inserted here -->
                
                
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>
