<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                xmlns:uriutils="org.ametys.core.util.URIUtils"
                extension-element-prefixes="ametys math">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">projects-catalogue</xsl:variable>
    <xsl:variable name="common-service-name">service-projects-catalogue</xsl:variable>
    
    <!-- +
         | HEAD
         + -->   
    <!-- Used by common -->
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="common-service-head-js">
        <script type="text/javascript">
            document.writeln("&lt;div class='join-project-dialog' id='join-project-dialog<xsl:value-of select="$uniqueId"/>' style='display:none'&gt;");
                document.writeln("&lt;div class='join-project-dialog-text'&gt;<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_CONFIRM_MESSAGE"/>&lt;/div&gt;");
            document.writeln("&lt;/div&gt;");
            document.writeln("&lt;div class='asktojoin-project-dialog' id='asktojoin-project-dialog<xsl:value-of select="$uniqueId"/>' style='display:none'&gt;");
                document.writeln("&lt;div class='asktojoin-project-dialog-text'&gt;<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_MODAL_HINT"/>&lt;/div&gt;");
                document.writeln("&lt;textarea rows='5' cols='80' class='asktojoin-project-dialog-textarea' id='asktojoin-project-textarea<xsl:value-of select="$uniqueId"/>'&gt;&lt;/textarea&gt;");
            document.writeln("&lt;/div&gt;");

            function joinProject_<xsl:value-of select="$uniqueId"/>(projectId)
            {
                $j("#join-project-dialog<xsl:value-of select="$uniqueId"/>").dialog({
                    resizable: false,
                    height: 'auto',
                    width: 'auto',
                    modal: true,
                    title: "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_CONFIRM_TITLE"/>",
                    buttons: {
                        "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_VALIDATE"/>": function () {
                            doJoinProject_<xsl:value-of select="$uniqueId"/>(projectId);
                        },
                        "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_CANCEL"/>": function () {
                            $j(this).dialog("close");
                        }
                    }
                });
            }

            function doJoinProject_<xsl:value-of select="$uniqueId"/>(projectId)
            {
                $j.ajax({
                    url: "<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/workspaces/projects/join-project",
                    data: {
                        projectId: projectId
                    },
                    dataType: "xml",
                    type: 'post',
                    success: function (response) {
                        if ($j(response).find("ActionResult>success").text() == "true")
                        {
                            setTimeout(function () {
                                alert('<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_SUCCESS"/>');
                                window.location.reload();
                            }, 10);
                        }
                        else
                        {
                            setTimeout(function () {
                                alert('<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_ERROR_MESSAGE"/>');
                            }, 10);
                        }
                    },
                    error: function () {
                        setTimeout(function () {
                            alert('<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_JOIN_ERROR_MESSAGE"/>');
                        }, 10);
                    },
                    complete: function () {
                        $j("#join-project-dialog<xsl:value-of select="$uniqueId"/>").dialog("close");
                    }
                });
            }

            function askToJoinProject_<xsl:value-of select="$uniqueId"/>(projectId)
            {
                $j("#asktojoin-project-dialog<xsl:value-of select="$uniqueId"/>").dialog({
                    resizable: false,
                    height: 'auto',
                    width: 'auto',
                    modal: true,
                    title: "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_MODAL_TITLE"/>",
                    buttons: {
                        "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_VALIDATE"/>": function () {
                            doAskToJoinProject_<xsl:value-of select="$uniqueId"/>(projectId);
                        },
                        "<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_CANCEL"/>": function () {
                            $j(this).dialog("close");
                        }
                    }
                });
            }

            function doAskToJoinProject_<xsl:value-of select="$uniqueId"/>(projectId)
            {
                $j.ajax({
                    url: "<xsl:value-of select="ametys:siteUriPrefix()"/>/_plugins/workspaces/projects/asktojoin-project",
                    data: {
                        projectId: projectId,
                        message: $j('#asktojoin-project-textarea<xsl:value-of select="$uniqueId"/>').val()
                    },
                    dataType: "xml",
                    type: 'post',
                    success: function (response) {
                        if ($j(response).find("ActionResult>success").text() == "true")
                        {
                            var withNotif = $j(response).find("ActionResult>added-notification").text();
                            $j("#asktojoin-project-dialog<xsl:value-of select="$uniqueId"/>").dialog("close");
                            setTimeout(function () {
                                alert(withNotif == "true" ? '<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_SUCCESS"/>' : '<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_SUCCESS_NO_NOTIF"/>');
                            }, 10);
                        }
                        else
                        {
                            setTimeout(function () {
                                alert('<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_ERROR_MESSAGE"/>');
                            }, 10);
                        }
                    },
                    error: function () {
                        setTimeout(function () {
                            alert('<i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_PROJECTS_CATALOGUE_PROJECT_ASKTOJOIN_ERROR_MESSAGE"/>');
                        }, 10);
                    }
                });
            }
        </script>
    </xsl:template>
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
    		<xsl:when test="//project">
                <xsl:if test="project">
                    <xsl:call-template name="projects" />
                </xsl:if>
            </xsl:when>
    		<xsl:otherwise>
    			<xsl:call-template name="projects-empty"/>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="projects-empty">
        <p><i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_NO_RESULTS" /></p>
    </xsl:template>
    
    <xsl:template name="projects">
        <ul class="projects">
            <xsl:apply-templates select="project" />
        </ul>
    </xsl:template>
    
    <xsl:template match="project">
        <li>
        	<xsl:attribute name="class"><xsl:call-template name="common-utils-class"/> project-entry</xsl:attribute>
            <xsl:call-template name="project-title"/>
            <xsl:call-template name="project-categories"/>
            <xsl:call-template name="project-description"/>
            <xsl:call-template name="project-manager"/>
            <xsl:call-template name="project-join"/>
        </li>
    </xsl:template>
    
    <xsl:template name="project-title">
    	<div class="project-title">
    		<xsl:choose>
    			<xsl:when test="@hasAccess = 'true'">
    				<a href="{url}" target="_blank" title="plugin.workspaces:PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_ACCESS" i18n:attr="title"><xsl:value-of select="title" /></a>
    			</xsl:when>
    			<xsl:otherwise>
    				<span class="project-access-not-allowed"><xsl:value-of select="title" /></span>
    			</xsl:otherwise>
    		</xsl:choose>
    	</div>
    </xsl:template>
    
    <xsl:template name="project-categories">
        <xsl:if test="categories/category">
            <div class="project-categories">
                <ul class="project-categories-list">
                    <xsl:for-each select="categories/category">
                        <li class="project-categories-listitem"><xsl:value-of select="title"/></li>
                    </xsl:for-each>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-description">
    	<xsl:if test="description != ''">
    		<div class="project-description"><xsl:value-of select="description" /></div>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template name="project-manager">
    	<xsl:if test="managers/manager">
            <xsl:for-each select="managers/manager">
       			<div class="project-manager">
    	    		<img class="project-manager-img" src="{$site-uri-prefix}/_plugins/user-directory/user/{@population}/{uriutils:encodePath(@login)}/image_24" />
    	            <span class="project-manager-name"><xsl:value-of select="fullname" /></span>
                </div>
            </xsl:for-each>
       	</xsl:if>
    </xsl:template>
    
    <xsl:template name="project-join">
        <xsl:if test="@hasAccess != 'true' and @inPopulations = 'true' and @inscriptionStatus = 'open'">
            <div class="project-join">
                <a href="javascript:void(0)" target="_blank" title="PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_JOIN" i18n:attr="title" onclick="joinProject_{$uniqueId}('{@id}'); return false;">
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_JOIN" />
                </a>
            </div>
        </xsl:if>
        <xsl:if test="@hasAccess != 'true' and @inPopulations = 'true' and @inscriptionStatus = 'moderated'">
            <div class="project-ask-to-join">
                <a href="javascript:void(0)" target="_blank" title="PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_JOIN" i18n:attr="title" onclick="askToJoinProject_{$uniqueId}('{@id}'); return false;">
                    <i18n:text i18n:key="PLUGINS_WORKSPACES_SERVICE_SIMPLE_PROJECTS_CATALOGUE_ASKTOJOIN" />
                </a>
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>
