/* 
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

(function() {
    // LOADING MESSAGE
    AmetysFront.Event.listen('loaderStart', function (options) {
        options = options || {};
        _display(_getOrCreateLoaderBar(), 'span', options.text || "{{i18n plugin.cms:PLUGINS_CMS_FRONT_SERVERCOMM_LOADER_DEFAULTTEXT}}");
    });

    // CONFIRM MESSAGE (with auto dismiss)
    var loaderEndTimer = null;
    AmetysFront.Event.listen('loaderEnd', function (options) {
        options = options || {};
        _hide(_getOrCreateLoaderBar());
        
        if (options.text != null)
        {
	        _display(_getOrCreateConfirmBar(), 'span', options.text);
	        
	        if (loaderEndTimer)
	        {
	            clearTimeout(loaderEndTimer);
	        }
	        loaderEndTimer = setTimeout(function() { _hide(_getOrCreateConfirmBar()) }, 3000);
        }
    });
    
    // FAILURE
    var errors = [];
    AmetysFront.Event.listen('loaderFail', function (options) {
        options = options || {};
        _hide(_getOrCreateLoaderBar());
        _hide(_getOrCreateConfirmBar());
        
        options.title = options.title || "{{i18n plugin.cms:PLUGINS_CMS_FRONT_SERVERCOMM_ERROR_DEFAULT}}"; 
        options.text = options.text || "{{i18n plugin.cms:PLUGINS_CMS_FRONT_SERVERCOMM_ERROR_DEFAULT_TEXT}}";
        
        if (options.fatal)
        {
            const svg = options.fatal == 'server' ? `<svg class="typeicon-server" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" width="72"><g><path d="M320.4,384H136c-14.6,0-28.5-2.6-41-7.2c-9.4-3.5-18-8.2-25.7-13.9c-11.5-8.5-20.8-19.3-27.2-31.9C35.7,318.5,32,304.1,32,288c0-12.1,1.8-22.8,5.1-32.3c2.4-7.1,5.7-13.6,9.6-19.5c5.9-8.8,13.3-16.4,22.2-22.7c8.8-6.3,18.9-11.4,30-15.1c8.4-2.8,12.9-11.9,10.1-20.3c-2.9-8.3-12-12.8-20.4-10c-12.3,4.1-23.9,9.7-34.6,16.7c-8,5.3-15.4,11.5-22,18.5c-9.9,10.5-18,23-23.5,37.3C3,254.8,0,270.7,0,288c0,18.7,3.8,36.2,10.9,51.9c5.3,11.7,12.3,22.4,20.7,31.8c12.7,14.1,28.5,25.1,46.2,32.7C95.6,412,115.3,416,136,416h184.4c8.8,0,16-7.2,16-16S329.2,384,320.4,384z"/><path d="M509.2,287.5c-3.2-13.5-9.1-25.3-16.7-35.3c-5.7-7.5-12.4-13.8-19.6-19.2c-10.9-8.1-22.9-14-35.2-18c-7.8-2.5-15.6-4.4-23.4-5.5c-3-19-8.4-36.5-15.7-52.4c-13.5-29.1-33.9-52.5-58.5-68.5c-24.7-16-53.6-24.5-84-24.5c-14.5,0-28.2,1.9-40.8,5.5c-12.7,3.5-24.4,8.6-35,14.9c-7.6,4.5-10.1,14.3-5.6,21.9c4.5,7.6,14.3,10.1,21.9,5.6c8.2-4.9,17.3-8.9,27.1-11.6c9.9-2.7,20.6-4.3,32.3-4.3c16.3,0,31.8,3,46.1,8.8c21.5,8.6,40.3,23.3,54.6,43.6c14.3,20.3,24.3,46.2,27.4,77.2c0.8,7.9,7.2,14,15.1,14.4c9.3,0.5,19.3,2.3,28.9,5.5c7.2,2.4,14.1,5.6,20.3,9.5c4.7,2.9,9,6.3,12.8,10.1c5.7,5.6,10.3,12.2,13.6,19.8c3.3,7.7,5.2,16.5,5.2,27.2c0,6.4-0.6,12.3-1.6,17.6c-1.6,8-4.2,14.8-7.7,20.6c-3.5,5.9-7.8,10.9-13,15.2c-6.8,5.6-7.7,15.7-2.1,22.5c5.5,6.7,15.6,7.6,22.4,2c5.2-4.3,10-9.3,14.3-14.8c6.3-8.3,11.3-17.8,14.6-28.4c3.3-10.6,5.1-22.3,5.1-34.8C512,303.4,511,295.2,509.2,287.5z"/><path d="M75.3,52.7c-6.2-6.2-16.4-6.2-22.6,0c-6.2,6.2-6.2,16.4,0,22.6l384,384c6.2,6.2,16.4,6.2,22.6,0s6.3-16.4,0-22.6L75.3,52.7z"/></g></svg>` : '';
            $j('html').addClass('offline offline-' + options.fatal);
            $j('body').append("<div class='offline'><div><div class='offline-title typeicon-" + options.fatal + "'>" + svg + options.title + "</div><div class='offline-message'>" + options.text + "</div></div><button onclick='window.location.reload(true)'>{{i18n plugin.cms:PLUGINS_CMS_FRONT_SERVERCOMM_ERROR_FATAL_RELOAD}}</button></div>");
        }
        else
        {
            errors.push(options);
            
            var code = '';
            for (var i=0; i < errors.length; i++)
            {
                code += '<li>';
                code +=     '<h1 title="' + errors[i].details + '">' + errors[i].title + '</h1>';
                code +=     '<span title="' + errors[i].details + '">' + errors[i].text + '</span>';
                code += '</li>';
            }
            
            var bar = _getOrCreateErrorBar();
            _display(bar, "ul", code);
        }

        window.console.error(options.title + '\n' + options.text
                    + (options.details ? '\n\n' + options.details : ''))
    });
    
    var _loader = null;
    function _getOrCreateLoaderBar()
    {
        _loader = _loader || _createBar("loading", "<div role='progressbar' aria-valuemin='0' aria-valuemax='100' class='ametys-basic-messages-icon'>"
                                                +      "<svg xmlns='http://www.w3.org/2000/svg' viewBox='23.529411764705884 23.529411764705884 47.05882352941177 47.05882352941177'><circle fill='transparent' cx='47.05882352941177' cy='47.05882352941177' r='20' stroke-width='7.058823529411765' stroke-dasharray='125.664' stroke-dashoffset='125.66370614359172px'></circle></svg>"
                                                +  "</div>", "<span></span>");
        return _loader;
    }
    var _confirm = null;
    function _getOrCreateConfirmBar()
    {
        _confirm = _confirm || _createBar("confirm", "<i aria-hidden='true' class='ametys-basic-messages-icon fa fa-check-circle'></i>", "<span></span>");
        return _confirm;
    }
    
    var _error = null;
    function _getOrCreateErrorBar()
    {
        _error = _error || _createBar("error", "<i aria-hidden='true' class='ametys-basic-messages-icon fa fa-exclamation-circle'></i>", "<ul></ul>");
        _error.find('button').on('click', function() { errors = []; });
        return _error
    }
    
    function _display(bar, selector, text)
    {
        if (text)
        {
            bar.find(selector).html(text);
        }
        bar.show();
        window.setTimeout(function() {
            // Defer this because the element need to be rendered the first time before adding the class in order to have correct css animation
            bar.addClass('ametys-basic-messages-active');
        }, 1)

    }
    
    function _hide(bar)
    {
        window.setTimeout(function() {
            // Defer this because a _hide called just after would have no effect otherwise
            bar.removeClass('ametys-basic-messages-active');
        }, 1)
    }
    
    function _createBar(suffix, iconCode, textCode)
    {
       var bar =  jQuery(document.body).append(
              "<div class='ametys-basic-messages ametys-basic-messages-" + suffix + "' style='display: none'>" 
            +     "<div role='status' aria-live='polite' class='ametys-basic-messages-content'>"
            +         iconCode
            +         textCode
            +     "</div>" 
            +     "<div class='ametys-basic-messages-action'>"
            +         "<button>{{i18n plugin.cms:PLUGINS_CMS_FRONT_SERVERCOMM_LOADER_CLOSE}}</button>"
            +     "</div>" 
            + "</div>")
            
            .children().last();
            
        bar.on('transitionend', function() { if (!bar.hasClass('ametys-basic-messages-active')) bar.hide(); });
        bar.find('button').on('click', function() { _hide(bar); });
        
        return bar;
    }
})();