<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">
    
	<xsl:import href="projectArticle.xsl"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-content-css-class-name">project-article view-abstract</xsl:variable>         
    
    
    <!-- +
         | BODY
         + -->
    <!-- Used in common.xsl --> 
    <xsl:template name="common-content-body-content">
        <!-- Image -->
        <xsl:call-template name="common-content-body-image-smallsize"/>    
    
        <!-- Abstract -->
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">content-abstract</xsl:with-param>
            <xsl:with-param name="text" select="metadata/abstract" />
            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
            <xsl:with-param name="maxDefaultTextSize" select="200" />
        </xsl:call-template>
        
        <!-- Read more -->
        <xsl:call-template name="common-content-body-readmore"/>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    </xsl:template>     
	
</xsl:stylesheet>
