<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
    
    <!-- +
         | Helper for items container
         + -->
    <xsl:template name="items-container">
        <xsl:param name="width">600</xsl:param>
        <xsl:param name="margin-right-0">false</xsl:param>
        <xsl:param name="inner-content"/>
        <xsl:param name="background-color"/>
        
        <xsl:call-template name="msoif-open">
            <xsl:with-param name="width" select="$width"/>
        </xsl:call-template>
        
        <div style="max-width: {$width}px; margin: 0px auto;">
            <table>
                <xsl:call-template name="table-layout-attributes"/>
                
                <tbody>
                    <tr>
                        <td id="itemstemplate">
                            <xsl:attribute name="style">background-color: <xsl:value-of select="$background-color"/>; direction: ltr; padding: 0px; word-break: break-word; border-radius: 8px; overflow: hidden;</xsl:attribute>
                            <table>
                                <xsl:call-template name="table-layout-attributes" />
                                <tbody>
                                    <tr>
                                        <td>
                                            <xsl:call-template name="td-layout-attributes"/>
                                            <xsl:copy-of select="$inner-content"/>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>     
                        </td>
                    </tr>
                </tbody>
            </table>
         </div>
         
         <xsl:call-template name="msoif-close"/>
    </xsl:template>
    
    
</xsl:stylesheet>