<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:v="urn:schemas-microsoft-com:vml"
                              xmlns:o="urn:schemas-microsoft-com:office:office"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
    
    <xsl:import href="view:workspaces://stylesheets/mail/standard/template.xsl"/>
   
    <!-- Additional styles -->
    <xsl:import href="components/styles.xsl"/>
    
    <!-- Overriden components -->
    <xsl:import href="components/footer.xsl"/>
    <xsl:import href="components/header.xsl"/>
    
    <!-- Additional components -->
    <xsl:import href="components/items.xsl"/>
    <xsl:import href="components/comment.xsl"/>
    <xsl:import href="components/link.xsl"/>
    <xsl:import href="components/hint.xsl"/>
    <xsl:import href="components/more.xsl"/>
    <xsl:import href="components/project-title.xsl"/>
    <xsl:import href="components/images.xsl"/>
    
    <!-- Items -->
    <xsl:import href="items/items.xsl"/>
    
    <!-- Additional variables -->
    <xsl:variable name="sitemapName">
        <xsl:choose>
            <xsl:when test="$lang != ''"><xsl:value-of select="$lang"/></xsl:when>
            <xsl:otherwise>fr</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="catalogSiteName" select="ametys:config('workspaces.catalog.site.name')"/>
    <xsl:variable name="catalogHomeUrl" select="ametys:siteParameter($catalogSiteName, 'url')"/>
    
    <xsl:template name="template">
        <html
          xmlns="http://www.w3.org/1999/xhtml"
          xmlns:v="urn:schemas-microsoft-com:vml"
          xmlns:o="urn:schemas-microsoft-com:office:office">
          
          <xsl:call-template name="head"/>
          
          <xsl:call-template name="body"/>
          
        </html>
    </xsl:template>
</xsl:stylesheet>
