/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.activities.tasks;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.jcr.RepositoryException;

import org.apache.commons.lang.StringUtils;

import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.plugins.workspaces.tasks.Task;

/**
 * {@link ActivityType} implementation for the assignment of a task
 */
public class TaskAssignedActivityType extends TasksActivityType
{
    /** data name for the assignees */
    public static final String ASSIGNEES = "assignees";
    
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException
    {
        super.setAdditionalActivityData(activity, parameters);
        
        Task task = (Task) parameters.get(ObservationConstants.ARGS_TASK);
        
        // FIXME WORKSPACES-1407 Store user identity instead of fullname in task assigned
        List<String> assignees = task.getAssignments().stream().map(identity -> _userHelper.getUserFullName(identity)).collect(Collectors.toList());
        activity.setValue(ASSIGNEES, StringUtils.join(assignees, ", "));
    }
    
    @Override
    public boolean isMergeable(Activity activity1, Activity activity2)
    {
        return false;
    }
}
