/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars;

/**
 * Calendar workflow aware interface
 */
public interface WorkflowAwareCalendar extends ModifiableCalendar
{
    /**
     * Get the name of the workflow of the calendar
     * @return the name of the workflow of the calendar
     */
    public String getWorkflowName();
    
    /**
     * set the name of the workflow of the calendar
     * @param workflowName The workflow name
     */
    public void setWorkflowName(String workflowName);
}
