/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.ArrayList;
import java.util.List;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;

/**
 * DAO for manipulating project's categories
 */
public class CategoriesDAO extends AbstractTagsDAO
{
    /** The category JCR DAO */
    protected CategoryJCRDAO _categoryJCRDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _categoryJCRDAO = (CategoryJCRDAO) manager.lookup(CategoryJCRDAO.ROLE);
    }
    
    @Override
    public String getTagProviderEPRole()
    {
        return CategoryProviderExtensionPoint.ROLE;
    }
    
    @Override
    protected AbstractJCRTagsDAO _getTagJCRDAO()
    {
        return _categoryJCRDAO;
    }

    @Override
    protected List<TagProvider< ? extends Tag>> getCustomTagProvider()
    {
        List<TagProvider<? extends Tag>> providers = new ArrayList<>();
        providers.add(_tagProviderExtPt.getExtension(CategoryJCRProvider.class.getName()));
        
        return providers;
    }
}
