/*
 *  Copyright 2010 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.documents.actions;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.servlet.multipart.Part;

import org.ametys.core.observation.AbstractNotifierAction;
import org.ametys.plugins.explorer.resources.AddOrUpdateResource;

/**
 * Action for adding or updating a resource file.
 * This Action is needed as vue dropzone needs an url to do a POST request, so we can not call directly the callable function from the front
 * Due to how vuedropzone works, files are uploaded one at a time
 */
public class AddOrUpdateResourceAction extends AbstractNotifierAction
{
    /** resource operation helper */
    protected AddOrUpdateResource _addOrUpdateResource;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _addOrUpdateResource = (AddOrUpdateResource) serviceManager.lookup(AddOrUpdateResource.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);

        Part part = (Part) request.get("filename");
        String parentId = request.getParameter("collection");
        
        boolean unzip = Boolean.valueOf(request.getParameter("unzip"));
        String rawMode = parameters.getParameter("mode", "add");
        
        if (unzip)
        {
            rawMode = "add-unzip";
        }

        _addOrUpdateResource.addOrUpdateResources(parentId, rawMode, unzip, List.of(part));

        return EMPTY_MAP;
    }
}
