/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members.solr;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

import org.ametys.cms.content.indexing.solr.SolrIndexer;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.Expression.Operator;
import org.ametys.plugins.workspaces.WorkspacesConstants;

/**
 * Schedulable to re-index all existing members
 */
public class ReindexMembersSchedulable extends AbstractStaticSchedulable
{
    /** The Solr indexer */
    protected SolrIndexer _solrIndexer;

    /** The ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _solrIndexer = (SolrIndexer) manager.lookup(SolrIndexer.ROLE);
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
    }
    
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        String xpathQuery = ContentQueryHelper.getContentXPathQuery(new ContentTypeExpression(Operator.EQ, WorkspacesConstants.MEMBER_CONTENT_TYPE_ID));
        AmetysObjectIterable<Content> searchResults = _resolver.query(xpathQuery);
        
        _solrIndexer.indexContents(searchResults, progressionTracker); // This indexes on all workspaces
    }
}
