/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tasks;

import java.time.ZonedDateTime;
import java.util.List;

import org.ametys.cms.data.ametysobject.ModifiableModelAwareDataAwareAmetysObject;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.RemovableAmetysObject;

/**
 * Task list interface
 */
public interface TasksList extends ModifiableModelAwareDataAwareAmetysObject, RemovableAmetysObject
{
    /**
     * The id of the task list
     * @return The id
     */
    public String getListId();
    
    /** 
     * Set the tasks list id
     * @param id the id
     */
    public void setListId(String id);
    
    /**
     * The position of the task list
     * @return The position
     */
    public Long getPosition();
    
    /** 
     * Set the tasks list position
     * @param position the position
     */
    public void setPosition(Long position);
    
    /**
     * The title of the task
     * @return The title
     */
    public String getLabel();
    
    /** 
     * Set the tasks list label
     * @param label the label
     */
    public void setLabel(String label);
    
    /**
     * Get the tasks list color
     * @return the tasks list color
     */
    public String getColor();
    
    /**
     * Set the tasks list color
     * @param colorId the color id
     */
    public void setColor(String colorId);
    
    /**
     * Get the tasks list icon
     * @return the tasks list icon
     */
    public String getIcon();
    
    /**
     * Set the tasks list icon
     * @param iconId the icon id
     */
    public void setIcon(String iconId);
    
    /**
     * Get the list of tasks
     * @return The list of tasks
     */
    public List<Task> getTasks();
    
    /**
     * Add a task
     * @param task The task
     */
    public void addTask(Task task);
    
    /**
     * Get the author of the task
     * @return the author
     */
    public UserIdentity getAuthor();
    
    /**
     * Set the author of this task.
     * @param author the author
     */
    public void setAuthor(UserIdentity author);
    
    /**
     * Get the task's creation date.
     * @return the task's creation date.
     */
    public ZonedDateTime getCreationDate();
    
    /**
     * Set the post's creation date.
     * @param startDate the post's creation date.
     */
    public void setCreationDate(ZonedDateTime startDate);
    
    /**
     * Get the task's last modification date.
     * @return the task's last modification date.
     */
    public ZonedDateTime getLastModified();
    
    /**
     * Set the post's modification date.
     * @param date the last modification date to set.
     */
    public void setLastModified(ZonedDateTime date);
}
