/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.tasks.taskexporter;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * Task exporter
 */
public interface TaskExporter
{

    /**
     * Get the label to display in the list
     * @return The list label
     */
    public I18nizableText getListLabel();

    /**
     * Get the label to display in the title
     * @return The title label
     */
    public I18nizableText getTitleLabel();
    
    /**
     * Get the label to display in the description
     * @return The title description
     */
    public I18nizableText getDescriptionLabel();
    
    /**
     * Get the icon to display
     * @return The icon
     */
    public String getIcon();

    /**
     * Get the URL call prefix
     * @return The URL call prefix
     */
    public String getUrlCallPrefix();
    
    /**
     * Get the opening mode
     * @return The opening mode
     */
    public String getOpeningMode();

}
