/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityHelper;
import org.ametys.plugins.repository.activities.ActivityTypeExpression;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.activities.activitystream.ActivityStreamClientInteraction;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModule;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.MoveablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.service.Service;
import org.ametys.web.service.ServiceExtensionPoint;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWorkspaceModule
extends AbstractLogEnabled
implements WorkspaceModule,
Serviceable,
Contextualizable,
PluginAware {
    protected static final Long __SIZE_ERROR = -1L;
    protected static final Long __SIZE_INACTIVE = -2L;
    protected ProjectManager _projectManager;
    protected ProjectRightHelper _projectRightHelper;
    protected UserManager _userManager;
    protected AmetysObjectResolver _resolver;
    protected RightManager _rightManager;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected UserHelper _userHelper;
    protected I18nUtils _i18nUtils;
    protected SkinsManager _skinsManager;
    protected PageDAO _pageDAO;
    protected Context _context;
    protected String _pluginName;
    protected ServiceExtensionPoint _serviceEP;
    protected WorkspaceModuleExtensionPoint _modulesEP;
    protected ActivityStreamClientInteraction _activityStream;
    protected WorkspacesHelper _wokspacesHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._projectRightHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._wokspacesHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._skinsManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._serviceEP = (ServiceExtensionPoint)manager.lookup(ServiceExtensionPoint.ROLE);
        this._modulesEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._activityStream = (ActivityStreamClientInteraction)((Object)manager.lookup(ActivityStreamClientInteraction.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    @Override
    public void deleteData(Project project) {
        this._deletePages(project);
        this._internalDeleteData(project);
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, false);
        if (moduleRoot != null) {
            moduleRoot.remove();
        }
        this._deleteActivities(project);
    }

    @Override
    public void deactivateModule(Project project) {
        this._setPagesVisibility(project, false);
        this._internalDeactivateModule(project);
    }

    @Override
    public void activateModule(Project project, Map<String, Object> additionalValues) {
        this.getModuleRoot(project, true);
        this._internalActivateModule(project, additionalValues);
        Site site = project.getSite();
        if (site != null) {
            for (Sitemap sitemap : site.getSitemaps()) {
                this.initializeSitemap(project, sitemap);
            }
        }
        this._setPagesVisibility(project, true);
    }

    @Override
    public void initializeSitemap(Project project, Sitemap sitemap) {
        ModifiablePage page = this._createModulePage(project, sitemap, this.getModulePageName(), this.getModulePageTitle(), this.getModulePageTemplate());
        if (page != null) {
            page.tag("SECTION");
            this._projectManager.tagProjectPage(page, this.getModuleRoot(project, true));
            this.initializeModulePage(page);
            page.saveChanges();
            HashMap<String, ModifiablePage> eventParams = new HashMap<String, ModifiablePage>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("page.added", this._currentUserProvider.getUser(), eventParams));
        }
    }

    @Override
    public String getModuleUrl(Project project) {
        Optional<String> url = this._projectManager.getModulePages(project, this).stream().findFirst().map(page -> ResolveURIComponent.resolve((String)"page", (String)page.getId()));
        if (url.isPresent()) {
            return url.get();
        }
        return null;
    }

    protected ModifiablePage _createModulePage(Project project, Sitemap sitemap, String name, I18nizableText pageTitle, String skinTemplate) {
        if (!sitemap.hasChild(name)) {
            ModifiablePage page = (ModifiablePage)sitemap.createChild(name, "ametys:defaultPage");
            page.setTitle((String)StringUtils.defaultIfEmpty((CharSequence)this._i18nUtils.translate((I18nizable)pageTitle, sitemap.getName()), (CharSequence)"Missing title"));
            page.setType(Page.PageType.NODE);
            page.setSiteName(sitemap.getSiteName());
            page.setSitemapName(sitemap.getName());
            Site site = page.getSite();
            Skin skin = this._skinsManager.getSkin(site.getSkinId());
            if (skinTemplate != null) {
                SkinTemplate template = skin.getTemplate(skinTemplate);
                if (template != null) {
                    page.setType(Page.PageType.CONTAINER);
                    page.setTemplate(skinTemplate);
                } else {
                    this.getLogger().error(String.format("The project workspace  '%s' was created with the skin '%s'  which doesn't possess the mandatory template '%s'.\nThe '%s' page of the project workspace could not be initialized.", site.getName(), site.getSkinId(), skinTemplate, page.getName()));
                }
            }
            sitemap.saveChanges();
            for (WorkspaceModule otherModule : this._modulesEP.getModules()) {
                Set<Page> modulePages;
                if (otherModule.compareTo(this) <= 0 || (modulePages = this._projectManager.getModulePages(project, otherModule)).isEmpty()) continue;
                ((MoveablePage)page).orderBefore((AmetysObject)modulePages.iterator().next());
                break;
            }
            sitemap.saveChanges();
            return page;
        }
        return null;
    }

    protected void _setPagesVisibility(Project project, boolean visible) {
        List modulePageIds = this._getModulePages(project).stream().filter(p -> !"index".equals(p.getPathInSitemap()) && (visible && !p.isVisible() || !visible && p.isVisible())).map(AmetysObject::getId).collect(Collectors.toList());
        this._pageDAO.setVisibility(modulePageIds, visible);
    }

    protected void _deletePages(Project project) {
        List<Page> modulePages = this._getModulePages(project);
        for (Page page : modulePages) {
            this._pageDAO.deletePage((ModifiablePage)page, true);
        }
    }

    protected List<Page> _getModulePages(Project project) {
        String modulePageName = this.getModulePageName();
        ArrayList<Page> pages = new ArrayList<Page>();
        Site site = project.getSite();
        if (site != null) {
            for (Sitemap sitemap : site.getSitemaps()) {
                if (!sitemap.hasChild(modulePageName)) continue;
                pages.add((Page)sitemap.getChild(modulePageName));
            }
        }
        return pages;
    }

    protected void _deleteActivities(Project project) {
        StringExpression projectExpression = new StringExpression("projectName", Expression.Operator.EQ, project.getName());
        ArrayList<ActivityTypeExpression> eventTypeExpressions = new ArrayList<ActivityTypeExpression>();
        for (String eventType : this.getAllowedEventTypes()) {
            eventTypeExpressions.add(new ActivityTypeExpression(Expression.Operator.EQ, eventType));
        }
        AndExpression moduleActivityExpression = new AndExpression(new Expression[]{projectExpression, new OrExpression((Expression[])eventTypeExpressions.toArray())});
        String query = ActivityHelper.getActivityXPathQuery((Expression)moduleActivityExpression);
        AmetysObjectIterable activities = this._resolver.query(query);
        for (Activity activity : activities) {
            activity.remove();
        }
    }

    protected String _getDefaultXslt(String serviceId) {
        ElementDefinition xsltParameterDefinition;
        Service service;
        Service service2 = service = this._serviceEP.hasExtension(serviceId) ? (Service)this._serviceEP.getExtension(serviceId) : null;
        if (service != null && (xsltParameterDefinition = (ElementDefinition)service.getParameters().get("xslt")) != null) {
            return (String)xsltParameterDefinition.getDefaultValue();
        }
        return "";
    }

    protected abstract String getModulePageName();

    protected abstract I18nizableText getModulePageTitle();

    protected String getModulePageTemplate() {
        return "project";
    }

    protected abstract void initializeModulePage(ModifiablePage var1);

    protected void _internalDeactivateModule(Project project) {
    }

    protected void _internalDeleteData(Project project) {
    }

    protected void _internalActivateModule(Project project, Map<String, Object> additionalValues) {
    }

    protected <A extends AmetysObject> A _getAmetysObject(ModifiableTraversableAmetysObject parent, String name, String type, boolean create) throws AmetysRepositoryException {
        AmetysObject object = null;
        if (parent.hasChild(name)) {
            object = parent.getChild(name);
        } else if (create) {
            object = parent.createChild(name, type);
            parent.saveChanges();
        }
        return (A)object;
    }

    @Override
    public Map<String, Object> getStatistics(Project project) {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        if (ArrayUtils.contains((Object[])project.getModules(), (Object)this.getId())) {
            statistics.put(this._getModuleLastActivityKey(), this._getModuleLastActivity(project));
            statistics.put(this._getModuleAtivateKey(), true);
            statistics.put(this.getModuleSizeKey(), this._getModuleSize(project));
            statistics.putAll(this._getInternalStatistics(project, true));
        } else {
            statistics.put(this._getModuleAtivateKey(), false);
            statistics.putAll(this._getInternalStatistics(project, false));
            statistics.put(this.getModuleSizeKey(), __SIZE_INACTIVE);
        }
        return statistics;
    }

    protected Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        return Map.of();
    }

    @Override
    public List<StatisticColumn> getStatisticModel() {
        ArrayList<StatisticColumn> statisticHeaders = new ArrayList<StatisticColumn>();
        if (this._showActivatedStatus()) {
            statisticHeaders.add(new StatisticColumn(this._getModuleAtivateKey(), this.getModuleTitle()).withGroup("general$activated").withType(StatisticsColumnType.BOOLEAN));
        }
        if (this._showLastActivity()) {
            statisticHeaders.add(new StatisticColumn(this._getModuleLastActivityKey(), this.getModuleTitle()).withGroup("general$lastActivity").withType(StatisticsColumnType.DATE));
        }
        if (this._showModuleSize()) {
            statisticHeaders.add(new StatisticColumn(this.getModuleSizeKey(), this.getModuleTitle()).withType(StatisticsColumnType.LONG).withGroup("general$size").withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderSize").isHidden(true));
        }
        statisticHeaders.addAll(this._getInternalStatisticModel());
        return statisticHeaders;
    }

    protected List<StatisticColumn> _getInternalStatisticModel() {
        return List.of();
    }

    @Override
    public String getModuleSizeKey() {
        return this.getModuleName() + "$size";
    }

    private String _getModuleAtivateKey() {
        return this.getModuleName() + "$activated";
    }

    private String _getModuleLastActivityKey() {
        return this.getModuleName() + "$lastActivity";
    }

    protected long _getModuleSize(Project project) {
        return 0L;
    }

    protected boolean _showActivatedStatus() {
        return true;
    }

    protected boolean _showModuleSize() {
        return false;
    }

    @Override
    public Set<String> getAllEventTypes() {
        return this.getAllowedEventTypes();
    }

    protected boolean _showLastActivity() {
        return this.getAllEventTypes().size() != 0;
    }

    protected ZonedDateTime _getModuleLastActivity(Project project) {
        return this._activityStream.getDateOfLastActivityByActivityType(project.getName(), this.getAllowedEventTypes());
    }

    @Override
    public ModifiableResourceCollection getModuleRoot(Project project, boolean create) {
        try {
            ExplorerNode projectRootNode = project.getExplorerRootNode();
            if (projectRootNode instanceof ModifiableResourceCollection) {
                ModifiableResourceCollection mProjectRootNode = (ModifiableResourceCollection)projectRootNode;
                return (ModifiableResourceCollection)this._getAmetysObject((ModifiableTraversableAmetysObject)mProjectRootNode, this.getModuleName(), "ametys:resources-collection", create);
            }
            throw new IllegalArgumentException("Root module '" + projectRootNode.getPath() + "' is not modifiable");
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the " + this.getModuleName() + " root node.", (Throwable)e);
        }
    }
}

