/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.workspaces.activities.documents.DocumentsActivityType;
import org.ametys.plugins.workspaces.activities.documents.ResourceReferenceElementType;

public class ResourceCreatedOrUpdatedActivityType
extends DocumentsActivityType {
    @Override
    public void setAdditionalActivityData(Activity activity, Map<String, Object> parameters) throws RepositoryException {
        super.setAdditionalActivityData(activity, parameters);
        HashSet<Object> resourceIds = new HashSet<Object>();
        if (parameters.containsKey("resources")) {
            resourceIds.addAll(((Map)parameters.get("resources")).keySet());
        } else {
            resourceIds.add((String)parameters.get("object.id"));
        }
        ResourceReferenceElementType.ResourceReference[] references = new ResourceReferenceElementType.ResourceReference[resourceIds.size()];
        int i = 0;
        for (String string : resourceIds) {
            JCRResource resource = (JCRResource)this._ametysObjectResolver.resolveById(string);
            Node resourceNode = resource.getNode();
            VersionManager versionManager = resourceNode.getSession().getWorkspace().getVersionManager();
            Version baseVersion = versionManager.getBaseVersion(resourceNode.getPath());
            references[i] = new ResourceReferenceElementType.ResourceReference(string, resource.getName(), null, resource.getMimeType(), baseVersion.getName());
            ++i;
        }
        activity.setValue("files", (Object)references);
    }
}

