/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.documents;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.RepositoryData;
import org.ametys.plugins.repository.data.type.ComplexRepositoryElementType;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ResourceReferenceElementType
extends AbstractElementType<ResourceReference>
implements ComplexRepositoryElementType<ResourceReference> {
    private static final String RESOURCE_REFERENCE_NODETYPE = "ametys:resourceReference";

    public String getRepositoryDataType() {
        return RESOURCE_REFERENCE_NODETYPE;
    }

    public boolean isSimple() {
        return false;
    }

    public String toString(ResourceReference value) {
        if (value != null) {
            return this._jsonUtils.convertObjectToJson(this._singleValueToJSON(value, DataContext.newInstance()));
        }
        return null;
    }

    protected ResourceReference convertValue(Object value) throws BadItemTypeException {
        if (value instanceof String) {
            String json = (String)value;
            return this._json2ResourceReference(this._jsonUtils.convertJsonToMap(json));
        }
        return (ResourceReference)super.convertValue(value);
    }

    protected ResourceReference _singleValueFromJSON(Object json, DataContext context) throws BadItemTypeException {
        if (json instanceof Map) {
            Map jsonMap = (Map)json;
            return this._json2ResourceReference(jsonMap);
        }
        throw new BadItemTypeException("Unable to convert the given json value '" + String.valueOf(json) + "' into a " + this.getManagedClass().getName());
    }

    private ResourceReference _json2ResourceReference(Map<String, Object> jsonMap) {
        String id = (String)jsonMap.get("id");
        String name = (String)jsonMap.get("name");
        String oldName = (String)jsonMap.get("oldName");
        String mimeType = (String)jsonMap.get("mimeType");
        String version = (String)jsonMap.get("version");
        return new ResourceReference(id, name, oldName, mimeType, version);
    }

    protected Object _singleTypedValueToJSON(ResourceReference value, DataContext context) {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("id", value.id());
        json.put("name", value.name());
        String oldName = value.oldName();
        if (oldName != null) {
            json.put("oldName", oldName);
        }
        json.put("mimeType", value.mimeType());
        String baseVersionName = value.baseVersionName();
        if (baseVersionName != null) {
            json.put("version", baseVersionName);
        }
        return json;
    }

    protected boolean _useJSONForEdition() {
        return true;
    }

    protected ResourceReference _singleValueFromXML(Element element, Optional<Object> additionalData) {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        String oldName = null;
        if (element.hasAttribute("oldName")) {
            oldName = element.getAttribute("oldName");
        }
        String mimeType = element.getAttribute("mimeType");
        String version = null;
        if (element.hasAttribute("version")) {
            version = element.getAttribute("version");
        }
        return new ResourceReference(id, name, oldName, mimeType, version);
    }

    protected void _singleTypedNotEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, ResourceReference value, DataContext context, AttributesImpl attributes) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        localAttributes.addCDATAAttribute("id", value.id());
        localAttributes.addCDATAAttribute("name", value.name());
        String oldName = value.oldName();
        if (oldName != null) {
            localAttributes.addCDATAAttribute("oldName", oldName);
        }
        localAttributes.addCDATAAttribute("mimeType", value.mimeType());
        String baseVersionName = value.baseVersionName();
        if (baseVersionName != null) {
            localAttributes.addCDATAAttribute("version", baseVersionName);
        }
        XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes, (String)value.name());
    }

    public boolean isSingleValueEmpty(RepositoryData singleValueData) {
        return this._isStringValueEmpty(singleValueData, "id") || this._isStringValueEmpty(singleValueData, "name") || this._isStringValueEmpty(singleValueData, "mimeType");
    }

    private boolean _isStringValueEmpty(RepositoryData referenceData, String name) {
        return !referenceData.hasValue(name) || StringUtils.isEmpty((CharSequence)referenceData.getString(name));
    }

    public ResourceReference readSingleValue(RepositoryData singleValueData) {
        String id = singleValueData.getString("id");
        String name = singleValueData.getString("name");
        String oldName = null;
        if (singleValueData.hasValue("oldName")) {
            oldName = singleValueData.getString("oldName");
        }
        String mimeType = singleValueData.getString("mimeType");
        String version = null;
        if (singleValueData.hasValue("version")) {
            version = singleValueData.getString("version");
        }
        return new ResourceReference(id, name, oldName, mimeType, version);
    }

    public void writeSingleValue(ModifiableRepositoryData parentData, String name, ResourceReference value) {
        if (value != null) {
            ModifiableRepositoryData referenceData = parentData.addRepositoryData(name, this.getRepositoryDataType());
            referenceData.setValue("id", value.id());
            referenceData.setValue("name", value.name());
            String oldName = value.oldName();
            if (oldName != null) {
                referenceData.setValue("oldName", value.oldName());
            }
            referenceData.setValue("mimeType", value.mimeType());
            String baseVersionName = value.baseVersionName();
            if (baseVersionName != null) {
                referenceData.setValue("version", baseVersionName);
            }
        }
    }

    public record ResourceReference(String id, String name, String oldName, String mimeType, String baseVersionName) {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String OLD_NAME = "oldName";
        public static final String MIME_TYPE = "mimeType";
        public static final String VERSION = "version";
    }
}

