/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities.projects;

import java.util.List;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.activities.ActivityType;
import org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityNotifier;
import org.ametys.plugins.workspaces.activities.projects.ContentCommentedActivityType;
import org.ametys.plugins.workspaces.activities.projects.NewsPublishedActivityType;
import org.ametys.plugins.workspaces.activities.projects.WebContentActivityType;

public class WebContentActivityNotifier
extends AbstractWorkspacesActivityNotifier {
    public boolean supports(ActivityType activityType) {
        return activityType instanceof WebContentActivityType;
    }

    @Override
    public String getMailBodyURI(Activity activity) {
        ActivityType activityType = activity.getActivityType();
        if (activityType instanceof ContentCommentedActivityType) {
            switch ((String)activity.getValue("contentType")) {
                case "org.ametys.plugins.workspaces.Content.projectNews": {
                    return "cocoon://_plugins/workspaces/notification-mail-news-comment";
                }
                case "org.ametys.plugins.workspaces.Content.wallContent": {
                    return "cocoon://_plugins/workspaces/notification-mail-wallcontent-comment";
                }
            }
            return "cocoon://_plugins/workspaces/notification-mail-comment";
        }
        if (activityType instanceof NewsPublishedActivityType) {
            return "cocoon://_plugins/workspaces/notification-mail-news-publication";
        }
        return "cocoon://_plugins/workspaces/notification-mail-wallcontent";
    }

    @Override
    public List<String> getSubjectI18nParams(Activity activity) {
        List<String> params = super.getSubjectI18nParams(activity);
        params.add((String)activity.getValue("contentTitle"));
        return params;
    }

    @Override
    public AmetysObject getTargetAmetysObject(Activity activity) {
        return this._resolver.resolveById((String)activity.getValue("contentId"));
    }
}

