/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.messagingconnector.MessagingConnector;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventAttendee;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEvent;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class MessagingConnectorCalendarManager
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = MessagingConnectorCalendarManager.class.getName();
    public static final String PROPERTY_SYNCHRONIZED_ID = "ametys-internal:synchronizedId";
    private MessagingConnector _messagingConnector;
    private UserManager _userManager;
    private AmetysObjectResolver _resolver;
    private I18nUtils _i18nUtils;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        boolean hasService = manager.hasService(MessagingConnector.ROLE);
        this._messagingConnector = hasService ? (MessagingConnector)manager.lookup(MessagingConnector.ROLE) : null;
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void setSynchronizedId(JCRCalendarEvent event, String synchronizedId) {
        try {
            event.getNode().setProperty(PROPERTY_SYNCHRONIZED_ID, synchronizedId);
            event.saveChanges();
        }
        catch (RepositoryException e) {
            this.getLogger().error("An error occurred setting synchronized id for event " + event.getId());
        }
    }

    public String getSynchronizedId(JCRCalendarEvent event) {
        try {
            Node eventNode = event.getNode();
            if (eventNode.hasProperty(PROPERTY_SYNCHRONIZED_ID)) {
                return eventNode.getProperty(PROPERTY_SYNCHRONIZED_ID).getString();
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error("An error occurred getting synchronized id for event " + event.getId());
        }
        return null;
    }

    public void setAttendees(String eventId, List<CalendarEventAttendee> attendees) {
        if (attendees != null) {
            JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
            try {
                event.setAttendees(attendees);
            }
            catch (RepositoryException e) {
                this.getLogger().error("An error occurred setting attendees for event " + eventId, (Throwable)e);
            }
        }
    }

    public void setOrganiser(String eventId, UserIdentity organiser) {
        JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
        if (organiser != null) {
            event.setOrganiser(organiser);
        }
    }

    public void addEventInvitation(Map<String, Object> parameters, String eventId) {
        List attendeesList = (List)parameters.get("attendees");
        List<CalendarEventAttendee> attendees = this._getAttendeeListFromParameter(attendeesList);
        this.setAttendees(eventId, attendees);
        Map organiserMap = (Map)parameters.get("organiser");
        UserIdentity organiser = this._getUserFromParameter(organiserMap);
        this.setOrganiser(eventId, organiser);
        if (organiser != null) {
            JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
            this._createEvent(event, organiser, attendees);
        }
    }

    public void editEventInvitation(Map<String, Object> parameters, String eventId) {
        JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
        List attendeesList = (List)parameters.get("attendees");
        List<CalendarEventAttendee> attendees = this._getAttendeeListFromParameter(attendeesList);
        try {
            if (attendees == null) {
                attendees = event.getAttendees();
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error("An error occurred getting attendees from repository for event " + event.getId());
        }
        this.setAttendees(eventId, attendees);
        Map organiserMap = (Map)parameters.get("organiser");
        UserIdentity organiserFromMap = this._getUserFromParameter(organiserMap);
        UserIdentity organiser = organiserFromMap != null ? organiserFromMap : event.getOrganiser();
        this.setOrganiser(eventId, organiser);
        if (this._messagingConnector != null) {
            String synchronizedId = this.getSynchronizedId(event);
            if (StringUtils.isNotBlank((CharSequence)synchronizedId) && this._messagingConnector.isEventExist(synchronizedId, organiser)) {
                this._editEvent(event, organiser, attendees);
            } else if (organiser != null) {
                this._createEvent(event, organiser, attendees);
            }
        }
    }

    protected void _createEvent(JCRCalendarEvent event, UserIdentity organiser, List<CalendarEventAttendee> attendees) {
        HashMap<String, Boolean> attendeesForMessagingConnector = new HashMap<String, Boolean>();
        for (CalendarEventAttendee attendee : attendees) {
            if (attendee.isExternal()) {
                attendeesForMessagingConnector.put(attendee.getEmail(), attendee.isMandatory());
                continue;
            }
            User user = this._userManager.getUser(new UserIdentity(attendee.getLogin(), attendee.getPopulationId()));
            attendeesForMessagingConnector.put(user.getEmail(), attendee.isMandatory());
        }
        String synchronizedId = this._messagingConnector.createEvent(this._getEventTitle(event), event.getDescription(), event.getLocation(), event.getFullDay().booleanValue(), event.getStartDate(), event.getEndDate(), event.getRecurrenceType(), event.getRepeatUntil(), attendeesForMessagingConnector, event.getOrganiser());
        this.setSynchronizedId(event, synchronizedId);
    }

    public void deleteEvent(JCRCalendarEvent event) {
        if (this.isEventSynchronized(event.getId())) {
            String synchronizedId = this.getSynchronizedId(event);
            this._messagingConnector.deleteEvent(synchronizedId, event.getOrganiser());
        }
    }

    public boolean isEventSynchronized(String eventId) {
        if (this._messagingConnector == null) {
            return false;
        }
        JCRCalendarEvent event = (JCRCalendarEvent)this._resolver.resolveById(eventId);
        String synchronizedId = this.getSynchronizedId(event);
        if (StringUtils.isBlank((CharSequence)synchronizedId)) {
            return false;
        }
        try {
            return this._messagingConnector.isEventExist(synchronizedId, event.getOrganiser());
        }
        catch (UnsupportedOperationException e) {
            this.getLogger().error("An error occurred while checking if event " + eventId + " exists", (Throwable)e);
            return false;
        }
    }

    protected void _editEvent(JCRCalendarEvent event, UserIdentity organiser, List<CalendarEventAttendee> attendees) {
        String synchronizedId = this.getSynchronizedId(event);
        HashMap<String, Boolean> attendeesForMessagingConnector = null;
        if (attendees != null) {
            attendeesForMessagingConnector = new HashMap<String, Boolean>();
            for (CalendarEventAttendee attendee : attendees) {
                if (attendee.isExternal()) {
                    attendeesForMessagingConnector.put(attendee.getEmail(), attendee.isMandatory());
                    continue;
                }
                User user = this._userManager.getUser(new UserIdentity(attendee.getLogin(), attendee.getPopulationId()));
                attendeesForMessagingConnector.put(user.getEmail(), attendee.isMandatory());
            }
        }
        this._messagingConnector.updateEvent(synchronizedId, this._getEventTitle(event), event.getDescription(), event.getLocation(), event.getFullDay().booleanValue(), event.getStartDate(), event.getEndDate(), event.getRecurrenceType(), event.getRepeatUntil(), attendeesForMessagingConnector, event.getOrganiser());
    }

    protected String _getEventTitle(JCRCalendarEvent event) {
        Calendar calendar = (Calendar)event.getParent();
        Project project = calendar.getProject();
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(project.getTitle());
        parameters.add(event.getTitle());
        I18nizableText titleI18n = new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_CALENDAR_ADD_EVENT_MESSAGING_CONNECTOR_TITLE", parameters);
        Request request = ContextHelper.getRequest((Context)this._context);
        String lang = (String)request.getAttribute("sitemapLanguage");
        return this._i18nUtils.translate((I18nizable)titleI18n, lang);
    }

    protected UserIdentity _getUserFromParameter(Map<String, Object> userMap) {
        if (userMap != null) {
            String login = (String)userMap.get("login");
            String populationId = (String)userMap.get("populationId");
            return new UserIdentity(login, populationId);
        }
        return null;
    }

    protected List<CalendarEventAttendee> _getAttendeeListFromParameter(List<Map<String, Object>> attendeesList) {
        if (attendeesList != null) {
            ArrayList<CalendarEventAttendee> attendees = new ArrayList<CalendarEventAttendee>();
            for (Map<String, Object> attendee : attendeesList) {
                CalendarEventAttendee calendarEventAttendee = new CalendarEventAttendee();
                boolean isExternal = (Boolean)attendee.get("external");
                if (isExternal) {
                    calendarEventAttendee.setEmail((String)attendee.get("email"));
                } else {
                    calendarEventAttendee.setPopulationId((String)attendee.get("populationId"));
                    calendarEventAttendee.setLogin((String)attendee.get("login"));
                }
                calendarEventAttendee.setIsExternal(isExternal);
                calendarEventAttendee.setIsMandatory((Boolean)attendee.get("mandatory"));
                attendees.add(calendarEventAttendee);
            }
            return attendees;
        }
        return null;
    }
}

