/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.generators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectsCatalogueManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FilteredEventsGenerator
extends ServiceableGenerator {
    private CalendarWorkspaceModule _calendarModule;
    private ProjectsCatalogueManager _projectCatalogManager;
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)serviceManager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._calendarModule = (CalendarWorkspaceModule)moduleManagerEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        this._projectCatalogManager = (ProjectsCatalogueManager)((Object)serviceManager.lookup(ProjectsCatalogueManager.ROLE));
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        int months = this.parameters.getParameterAsInteger("search-period", 3);
        int max = this.parameters.getParameterAsInteger("max-results", Integer.MAX_VALUE);
        List<String> calendarIds = null;
        List<String> tagIds = null;
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"events");
        this._calendarModule.getUpcomingEvents(months, max, calendarIds, tagIds).stream().forEach(this::_saxEvent);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"events");
        this.contentHandler.endDocument();
    }

    protected void _saxEvent(Map<String, Object> eventData) {
        try {
            String eventUrl;
            boolean calendarHasViewRight = BooleanUtils.isTrue((Boolean)((Boolean)eventData.get("calendarHasViewRight")));
            boolean calendarIsPublic = BooleanUtils.isTrue((Boolean)((Boolean)eventData.get("calendarIsPublic")));
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", (String)eventData.get("id"));
            attrs.addCDATAAttribute("calendarHasViewRight", Boolean.toString(calendarHasViewRight));
            attrs.addCDATAAttribute("calendarIsPublic", Boolean.toString(calendarIsPublic));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"event", (Attributes)attrs);
            attrs.clear();
            String projectId = (String)eventData.get("projectId");
            attrs.addCDATAAttribute("id", (String)eventData.get(projectId));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"project", (String)((String)eventData.get("projectTitle")));
            Project project = (Project)this._resolver.resolveById(projectId);
            this._projectCatalogManager.saxCategory(this.contentHandler, project, "projectCategory");
            Map calendarData = (Map)eventData.get("calendar");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"calendar", (String)((String)calendarData.get("title")));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)((String)eventData.get("title")));
            String startDate = (String)eventData.get("startDate");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"startDate", (String)startDate);
            if (calendarHasViewRight && StringUtils.isNotEmpty((CharSequence)(eventUrl = (String)eventData.get("eventUrl")))) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"eventUrl", (String)eventUrl);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"event");
        }
        catch (SAXException e) {
            throw new RuntimeException("An error occurred while gathering the events' information.");
        }
    }
}

