/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.jcr;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.ametys.cms.data.holder.ModifiableIndexableDataHolder;
import org.ametys.cms.data.holder.impl.DefaultModifiableModelAwareDataHolder;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.repositorydata.ModifiableRepositoryData;
import org.ametys.plugins.repository.data.repositorydata.impl.JCRRepositoryData;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObjectFactory;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObjectHelper;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventAttendee;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.events.ModifiableCalendarEvent;
import org.ametys.plugins.workspaces.calendars.helper.RecurrentEventHelper;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarEventFactory;
import org.ametys.runtime.model.ModelItemContainer;

public class JCRCalendarEvent
extends DefaultTraversableAmetysObject<JCRCalendarEventFactory>
implements ModifiableCalendarEvent,
WorkflowAwareAmetysObject {
    public static final String ATTRIBUTE_CREATOR = "creator";
    public static final String ATTRIBUTE_CREATION = "creationDate";
    public static final String ATTRIBUTE_CONTRIBUTOR = "contributor";
    public static final String ATTRIBUTE_MODIFIED = "lastModified";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_DESC = "description";
    public static final String ATTRIBUTE_KEYWORDS = "keywords";
    public static final String ATTRIBUTE_LOCATION = "location";
    public static final String ATTRIBUTE_START_DATE = "startDate";
    public static final String ATTRIBUTE_END_DATE = "endDate";
    public static final String ATTRIBUTE_DATE_ZONE = "dateZone";
    public static final String ATTRIBUTE_FULL_DAY = "fullDay";
    public static final String ATTRIBUTE_RECURRENCE_TYPE = "recurrenceType";
    public static final String ATTRIBUTE_UNTIL_DATE = "untilDate";
    public static final String ATTRIBUTE_EXCLUDED_DATE = "excludedDate";
    public static final String ATTRIBUTE_ORGANISER = "organiser";
    public static final String PROPERTY_ATTENDEE_POPULATION = "populationId";
    public static final String PROPERTY_ATTENDEE_LOGIN = "login";
    public static final String PROPERTY_ATTENDEE_EMAIL = "email";
    public static final String PROPERTY_ATTENDEE_EXTERNAL = "external";
    public static final String PROPERTY_ATTENDEE_MANDATORY = "mandatory";
    public static final String NODE_ATTENDEES_NAME = "ametys:calendar-event-attendees";
    public static final String NODE_ATTENDEE_NAME = "ametys:calendar-event-attendee";
    public static final String PROPERTY_WORKFLOW_ID = "ametys-internal:workflowId";
    public static final String ATTRIBUTE_RESOURCES = "resources";

    public JCRCalendarEvent(Node node, String parentPath, JCRCalendarEventFactory factory) {
        super(node, parentPath, (DefaultTraversableAmetysObjectFactory)factory);
    }

    @Override
    public Calendar getCalendar() {
        return (Calendar)this.getParent();
    }

    @Override
    public String getTitle() {
        return (String)this.getValue(ATTRIBUTE_TITLE);
    }

    @Override
    public String getDescription() {
        return (String)this.getValue(ATTRIBUTE_DESC);
    }

    @Override
    public String getLocation() {
        return (String)this.getValue(ATTRIBUTE_LOCATION, true, null);
    }

    public void tag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.tag((JCRAmetysObject)this, (String)tag);
    }

    public void untag(String tag) throws AmetysRepositoryException {
        TaggableAmetysObjectHelper.untag((JCRAmetysObject)this, (String)tag);
    }

    public Set<String> getTags() throws AmetysRepositoryException {
        return TaggableAmetysObjectHelper.getTags((JCRAmetysObject)this);
    }

    @Override
    public ZonedDateTime getStartDate() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_START_DATE);
    }

    @Override
    public ZonedDateTime getEndDate() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_END_DATE);
    }

    @Override
    public ZoneId getZone() {
        String zoneId;
        if (this.hasValue(ATTRIBUTE_DATE_ZONE) && ZoneId.of(zoneId = (String)this.getValue(ATTRIBUTE_DATE_ZONE)) != null) {
            return ZoneId.of(zoneId);
        }
        return ZoneId.systemDefault();
    }

    @Override
    public Boolean getFullDay() {
        return (Boolean)this.getValue(ATTRIBUTE_FULL_DAY);
    }

    @Override
    public UserIdentity getCreator() {
        return (UserIdentity)this.getValue(ATTRIBUTE_CREATOR);
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_CREATION);
    }

    @Override
    public UserIdentity getLastContributor() {
        return (UserIdentity)this.getValue(ATTRIBUTE_CONTRIBUTOR);
    }

    @Override
    public ZonedDateTime getLastModified() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_MODIFIED);
    }

    @Override
    public EventRecurrenceTypeEnum getRecurrenceType() {
        String recurrenceType = (String)this.getValue(ATTRIBUTE_RECURRENCE_TYPE, true, EventRecurrenceTypeEnum.NEVER.toString());
        EventRecurrenceTypeEnum recurrenceEnum = EventRecurrenceTypeEnum.valueOf((String)recurrenceType);
        return recurrenceEnum;
    }

    @Override
    public Boolean isRecurrent() {
        return !this.getRecurrenceType().equals((Object)EventRecurrenceTypeEnum.NEVER);
    }

    @Override
    public ZonedDateTime getRepeatUntil() {
        return (ZonedDateTime)this.getValue(ATTRIBUTE_UNTIL_DATE);
    }

    private ZonedDateTime _getUntilDate() {
        ZonedDateTime untilDate = this.getRepeatUntil();
        if (untilDate != null) {
            untilDate = untilDate.plusDays(1L);
        }
        return untilDate;
    }

    @Override
    public List<ZonedDateTime> getExcludedOccurences() {
        ZonedDateTime[] excludedOccurences = (ZonedDateTime[])this.getValue(ATTRIBUTE_EXCLUDED_DATE, false, new ZonedDateTime[0]);
        return Arrays.asList(excludedOccurences);
    }

    @Override
    public UserIdentity getOrganiser() {
        return (UserIdentity)this.getValue(ATTRIBUTE_ORGANISER);
    }

    @Override
    public List<String> getResources() {
        String[] resources = (String[])this.getValue(ATTRIBUTE_RESOURCES, false, new String[0]);
        return Arrays.asList(resources);
    }

    @Override
    public void setTitle(String title) {
        this.setValue(ATTRIBUTE_TITLE, title);
    }

    @Override
    public void setDescription(String desc) {
        this.setValue(ATTRIBUTE_DESC, desc);
    }

    @Override
    public void setLocation(String location) {
        this.setValue(ATTRIBUTE_LOCATION, location);
    }

    @Override
    public void setStartDate(ZonedDateTime startDate) {
        this.setValue(ATTRIBUTE_START_DATE, startDate);
    }

    @Override
    public void setEndDate(ZonedDateTime endDate) {
        this.setValue(ATTRIBUTE_END_DATE, endDate);
    }

    @Override
    public void setZone(ZoneId dateZone) {
        this.setValue(ATTRIBUTE_DATE_ZONE, dateZone.getId());
    }

    @Override
    public void setFullDay(Boolean fullDay) {
        this.setValue(ATTRIBUTE_FULL_DAY, fullDay);
    }

    @Override
    public void setCreator(UserIdentity user) {
        try {
            Node creatorNode = null;
            creatorNode = this.getNode().hasNode("ametys:creator") ? this.getNode().getNode("ametys:creator") : this.getNode().addNode("ametys:creator", "ametys:user");
            creatorNode.setProperty("ametys:login", user.getLogin());
            creatorNode.setProperty("ametys:population", user.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the creator property.", (Throwable)e);
        }
    }

    @Override
    public void setCreationDate(ZonedDateTime date) {
        this.setValue(ATTRIBUTE_CREATION, date);
    }

    @Override
    public void setLastContributor(UserIdentity user) {
        try {
            Node creatorNode = null;
            creatorNode = this.getNode().hasNode("ametys:contributor") ? this.getNode().getNode("ametys:contributor") : this.getNode().addNode("ametys:contributor", "ametys:user");
            creatorNode.setProperty("ametys:login", user.getLogin());
            creatorNode.setProperty("ametys:population", user.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the contributor property.", (Throwable)e);
        }
    }

    @Override
    public void setLastModified(ZonedDateTime date) {
        this.setValue(ATTRIBUTE_MODIFIED, date);
    }

    @Override
    public void setRecurrenceType(String recurrenceType) {
        this.setValue(ATTRIBUTE_RECURRENCE_TYPE, recurrenceType);
    }

    @Override
    public void setRepeatUntil(ZonedDateTime untilDate) {
        if (untilDate == null) {
            if (this.hasValue(ATTRIBUTE_UNTIL_DATE)) {
                this.removeValue(ATTRIBUTE_UNTIL_DATE);
            }
        } else {
            this.setValue(ATTRIBUTE_UNTIL_DATE, untilDate);
        }
    }

    @Override
    public void setExcludedOccurrences(List<ZonedDateTime> excludedOccurrences) {
        this.setValue(ATTRIBUTE_EXCLUDED_DATE, excludedOccurrences.toArray(new ZonedDateTime[excludedOccurrences.size()]));
    }

    @Override
    public List<CalendarEventOccurrence> getOccurrences(ZonedDateTime startDate, ZonedDateTime endDate) {
        Optional<CalendarEventOccurrence> optionalEvent = this.getFirstOccurrence(startDate);
        if (optionalEvent.isPresent() && optionalEvent.get().getStartDate().isBefore(endDate)) {
            return RecurrentEventHelper.getOccurrences(optionalEvent.get().getStartDate(), endDate, optionalEvent.get().getStartDate(), optionalEvent.get().getStartDate(), this.getRecurrenceType(), this.getExcludedOccurences(), this.getZone(), this._getUntilDate()).stream().map(occurrenceStartDate -> new CalendarEventOccurrence(this, (ZonedDateTime)occurrenceStartDate)).collect(Collectors.toList());
        }
        return new ArrayList<CalendarEventOccurrence>();
    }

    @Override
    public Optional<CalendarEventOccurrence> getFirstOccurrence(ZonedDateTime date) {
        ZonedDateTime eventStartDate = this.getStartDate();
        ZonedDateTime eventEndDate = this.getEndDate();
        if (this.getFullDay().booleanValue()) {
            eventEndDate = eventEndDate.plusDays(1L);
        }
        if (eventEndDate.isAfter(date) || eventEndDate.isEqual(date)) {
            return Optional.of(new CalendarEventOccurrence(this, eventStartDate));
        }
        if (this.isRecurrent().booleanValue()) {
            ZonedDateTime untilDate = this._getUntilDate();
            long eventDuringTime = ChronoUnit.SECONDS.between(eventStartDate, eventEndDate);
            ZonedDateTime endDate = eventEndDate;
            ZonedDateTime startDate = eventStartDate;
            while (startDate != null && endDate.isBefore(date)) {
                startDate = RecurrentEventHelper.getNextDate(this.getRecurrenceType(), this.getStartDate().withZoneSameInstant(this.getZone()), startDate.withZoneSameInstant(this.getZone()));
                if (startDate == null) continue;
                endDate = startDate.plusSeconds(eventDuringTime);
            }
            if (untilDate == null || untilDate.isAfter(startDate)) {
                return Optional.of(new CalendarEventOccurrence(this, startDate));
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<CalendarEventOccurrence> getNextOccurrence(CalendarEventOccurrence occurrence) {
        ZonedDateTime untilDate = this._getUntilDate();
        ZonedDateTime nextDate = RecurrentEventHelper.getNextDate(this.getRecurrenceType(), this.getStartDate().withZoneSameInstant(this.getZone()), occurrence.getStartDate().withZoneSameInstant(this.getZone()));
        if (nextDate != null && (untilDate == null || untilDate.isAfter(nextDate))) {
            return Optional.of(new CalendarEventOccurrence(this, nextDate));
        }
        return Optional.empty();
    }

    public long getWorkflowId() throws AmetysRepositoryException {
        try {
            return this.getNode().getProperty(PROPERTY_WORKFLOW_ID).getLong();
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to get workflowId property", (Throwable)e);
        }
    }

    public void setWorkflowId(long workflowId) throws AmetysRepositoryException {
        Node node = this.getNode();
        try {
            node.setProperty(PROPERTY_WORKFLOW_ID, workflowId);
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to set workflowId property", (Throwable)e);
        }
    }

    public long getCurrentStepId() {
        throw new UnsupportedOperationException();
    }

    public void setCurrentStepId(long stepId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOrganiser(UserIdentity user) {
        try {
            Node creatorNode = null;
            creatorNode = this.getNode().hasNode("ametys:organiser") ? this.getNode().getNode("ametys:organiser") : this.getNode().addNode("ametys:organiser", "ametys:user");
            creatorNode.setProperty("ametys:login", user.getLogin());
            creatorNode.setProperty("ametys:population", user.getPopulationId());
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Error setting the organiser property.", (Throwable)e);
        }
    }

    public List<CalendarEventAttendee> getAttendees() throws RepositoryException {
        ArrayList<CalendarEventAttendee> attendees = new ArrayList<CalendarEventAttendee>();
        Node calendarEventNode = this.getNode();
        if (calendarEventNode.hasNode(NODE_ATTENDEES_NAME)) {
            Node attendeesNode = calendarEventNode.getNode(NODE_ATTENDEES_NAME);
            NodeIterator nodes = attendeesNode.getNodes();
            while (nodes.hasNext()) {
                Node attendeeNode = (Node)nodes.next();
                CalendarEventAttendee attendee = new CalendarEventAttendee();
                boolean isExternal = attendeeNode.getProperty(PROPERTY_ATTENDEE_EXTERNAL).getBoolean();
                if (isExternal) {
                    attendee.setEmail(attendeeNode.getProperty(PROPERTY_ATTENDEE_EMAIL).getString());
                } else {
                    attendee.setLogin(attendeeNode.getProperty(PROPERTY_ATTENDEE_LOGIN).getString());
                    attendee.setPopulationId(attendeeNode.getProperty(PROPERTY_ATTENDEE_POPULATION).getString());
                }
                attendee.setIsExternal(isExternal);
                attendee.setIsMandatory(attendeeNode.getProperty(PROPERTY_ATTENDEE_MANDATORY).getBoolean());
                attendees.add(attendee);
            }
        }
        return attendees;
    }

    public void setAttendees(List<CalendarEventAttendee> attendees) throws RepositoryException {
        Node calendarEventNode = this.getNode();
        if (calendarEventNode.hasNode(NODE_ATTENDEES_NAME)) {
            calendarEventNode.getNode(NODE_ATTENDEES_NAME).remove();
        }
        Node attendeesNode = calendarEventNode.addNode(NODE_ATTENDEES_NAME, "ametys:unstructured");
        for (CalendarEventAttendee attendee : attendees) {
            Node attendeeNode = attendeesNode.addNode(NODE_ATTENDEE_NAME, "ametys:unstructured");
            if (attendee.isExternal()) {
                attendeeNode.setProperty(PROPERTY_ATTENDEE_EMAIL, attendee.getEmail());
            } else {
                attendeeNode.setProperty(PROPERTY_ATTENDEE_POPULATION, attendee.getPopulationId());
                attendeeNode.setProperty(PROPERTY_ATTENDEE_LOGIN, attendee.getLogin());
            }
            attendeeNode.setProperty(PROPERTY_ATTENDEE_EXTERNAL, attendee.isExternal());
            attendeeNode.setProperty(PROPERTY_ATTENDEE_MANDATORY, attendee.isMandatory());
        }
    }

    @Override
    public void setResources(List<String> resources) {
        this.setValue(ATTRIBUTE_RESOURCES, resources.toArray(new String[resources.size()]));
    }

    public ModifiableIndexableDataHolder getDataHolder() {
        JCRRepositoryData repositoryData = new JCRRepositoryData(this.getNode());
        return new DefaultModifiableModelAwareDataHolder((ModifiableRepositoryData)repositoryData, (ModelItemContainer)((JCRCalendarEventFactory)this._getFactory()).getCalendarEventModel());
    }
}

