/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.tag.AbstractTagProvider;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.TagTargetType;
import org.ametys.cms.tag.TagTargetTypeExtensionPoint;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryCMSTag;
import org.ametys.plugins.workspaces.categories.CategoryJCRProvider;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class CategoryTagProvider
extends AbstractTagProvider<CMSTag>
implements Serviceable {
    protected TagTargetTypeExtensionPoint _targetTypeEP;
    protected CategoryProviderExtensionPoint _categoryProviderEP;
    protected CategoryJCRProvider _jcrCategoryProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._targetTypeEP = (TagTargetTypeExtensionPoint)smanager.lookup(TagTargetTypeExtensionPoint.ROLE);
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)smanager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._jcrCategoryProvider = (CategoryJCRProvider)((Object)this._categoryProviderEP.getExtension(CategoryJCRProvider.class.getName()));
    }

    public Map<String, CMSTag> getTags(Map<String, Object> contextualParameters) {
        HashMap<String, CMSTag> cmsTags = new HashMap<String, CMSTag>();
        Map categories = this._jcrCategoryProvider.getTags(contextualParameters);
        for (Map.Entry category : categories.entrySet()) {
            CategoryCMSTag categoryTag = this._transformToCMSTag((Category)category.getValue(), contextualParameters);
            cmsTags.put(categoryTag.getId(), (CMSTag)this._transformToCMSTag((Category)category.getValue(), contextualParameters));
        }
        return cmsTags;
    }

    public CMSTag getTag(String tagName, Map<String, Object> contextualParameters) {
        String categoryName = tagName;
        if (categoryName.startsWith("WORKSPACES_CATEGORY_")) {
            categoryName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_CATEGORY_");
            return this._transformToCMSTag((Category)this._jcrCategoryProvider.getTag(categoryName, contextualParameters), contextualParameters);
        }
        return null;
    }

    public Collection<CMSTag> getTags(String tagName, Map<String, Object> contextualParameters) {
        String categoryName = tagName;
        if (categoryName.startsWith("WORKSPACES_CATEGORY_")) {
            categoryName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_CATEGORY_");
            Collection<Category> categories = this._jcrCategoryProvider.getTags(categoryName, contextualParameters);
            return categories.stream().map(tag -> this._transformToCMSTag((Category)tag, contextualParameters)).collect(Collectors.toList());
        }
        return List.of();
    }

    public boolean hasTag(String tagName, Map<String, Object> contextualParameters) {
        String categoryName = tagName;
        if (categoryName.startsWith("WORKSPACES_CATEGORY_")) {
            categoryName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_CATEGORY_");
            return this._jcrCategoryProvider.hasTag(categoryName, contextualParameters);
        }
        return false;
    }

    protected CategoryCMSTag _transformToCMSTag(Category category, Map<String, Object> contextualParameters) {
        if (category != null) {
            CMSTag parentTag = null;
            Category parentCategory = category.getParent();
            if (parentCategory != null) {
                parentTag = this.getTag(parentCategory.getName(), contextualParameters);
            }
            String typeName = "CONTENT";
            TagTargetType targetType = this._targetTypeEP.getTagTargetType(typeName);
            return new CategoryCMSTag(category, parentTag, targetType);
        }
        return null;
    }

    public List<String> getCSSUrls(Map<String, Object> contextualParameters) {
        List cssUrls = super.getCSSUrls(contextualParameters);
        cssUrls.add("/plugins/workspaces/project-categories.min.css");
        return cssUrls;
    }
}

