/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.comment.contributor.AbstractCommentNotifyMentionsObserver;
import org.ametys.cms.repository.mentions.AbstractNotifyMentionsObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.project.rights.ProjectRightHelper;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public abstract class AbstractNotifyWorkspacesCommentMentionsObserver<T extends CommentableAmetysObject>
extends AbstractCommentNotifyMentionsObserver<T>
implements Contextualizable {
    protected RightManager _rightManager;
    protected ProjectManager _projectManager;
    protected TasksWorkspaceModule _taskModule;
    protected DocumentWorkspaceModule _documentModule;
    protected WorkspacesHelper _workspaceHelper;
    protected Context _context;
    protected ProjectRightHelper _projectRightsHelper;
    protected RenderingContextHandler _renderingContextHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        WorkspaceModuleExtensionPoint moduleManagerEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._taskModule = (TasksWorkspaceModule)moduleManagerEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        this._documentModule = (DocumentWorkspaceModule)moduleManagerEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._projectRightsHelper = (ProjectRightHelper)((Object)manager.lookup(ProjectRightHelper.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map arguments = event.getArguments();
        T ametysObject = this._getAmetysObjectFromArguments(arguments);
        Project project = this._projectManager.getParentProject((AmetysObject)ametysObject);
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("site", (Object)project.getName());
        super.observe(event, transientVars);
    }

    protected String _getLanguage(Project project) {
        return this._workspaceHelper.getLang(project);
    }

    protected T _getAmetysObjectFromArguments(Map<String, Object> arguments) {
        String ametysObjectId = (String)arguments.get("object.id");
        CommentableAmetysObject ametysObject = (CommentableAmetysObject)this._resolver.resolveById(ametysObjectId);
        return (T)ametysObject;
    }

    protected StandardMailBodyHelper.MailBodyBuilder getStandardMailBodyHelper() {
        return StandardMailBodyHelper.newHTMLBody();
    }

    protected I18nizableText _getMailSubject(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        Project project = this._projectManager.getParentProject(mentionableObject.ametysObject());
        List<String> i18nParams = List.of(project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WORKSPACES_MENTION_MAIL_TITLE", i18nParams);
    }

    protected I18nizableText _getMailTitle(AbstractNotifyMentionsObserver.MentionableObject mentionableObject) {
        AmetysObject ametysObject = mentionableObject.ametysObject();
        Project project = this._projectManager.getParentProject(ametysObject);
        List<String> i18nParams = List.of(project.getTitle());
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_WORKSPACES_MENTION_MAIL_SUBJECT", i18nParams);
    }

    protected boolean _canSendMailToMentionedUser(T ametysObject, User authorIdentity, UserIdentity mentionedUserIdentity) {
        Project project = this._projectManager.getParentProject((AmetysObject)ametysObject);
        return super._canSendMailToMentionedUser(ametysObject, authorIdentity, mentionedUserIdentity) && this._projectRightsHelper.hasReadAccessOnModule(project, this._getModuleId(), mentionedUserIdentity);
    }

    protected abstract String _getModuleId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String _getAbsoluteUrl(T ametysObject, Project project) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("forceAbsoluteUrl", (Object)true);
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
        try {
            String string = this.getUrl(ametysObject, project);
            return string;
        }
        finally {
            this._renderingContextHandler.setRenderingContext(currentContext);
        }
    }

    protected abstract String getUrl(T var1, Project var2);
}

