/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.comments;

import java.util.Map;
import java.util.Optional;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.web.URIPrefixHandler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CommentsDAO
extends org.ametys.web.repository.comment.CommentsDAO {
    protected UserDirectoryHelper _userDirectoryHelper;
    protected URIPrefixHandler _prefixHandler;
    private WorkspacesHelper _workspaceHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._populationContextHelper = (PopulationContextHelper)smanager.lookup(PopulationContextHelper.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)smanager.lookup(UserDirectoryHelper.ROLE);
        this._prefixHandler = (URIPrefixHandler)smanager.lookup(URIPrefixHandler.ROLE);
        this._workspaceHelper = (WorkspacesHelper)((Object)smanager.lookup(WorkspacesHelper.ROLE));
    }

    protected void saxCommentAdditionalProperties(ContentHandler contentHandler, Comment comment, int level, Map<String, Object> contextualParameters) throws SAXException {
        super.saxCommentAdditionalProperties(contentHandler, comment, level, contextualParameters);
        String lang = (String)contextualParameters.get("sitemapLanguage");
        Optional<UserIdentity> optAuthorIdentity = this.getAuthorIdentity(comment, contextualParameters);
        if (optAuthorIdentity.isPresent()) {
            UserIdentity authorIdentity = optAuthorIdentity.get();
            Content userContent = this._userDirectoryHelper.getUserContent(authorIdentity, lang);
            if (userContent != null) {
                this._saxUserImage(contentHandler, authorIdentity, userContent.getLanguage());
                this._saxAdditionalUserProperties(contentHandler, userContent);
            } else {
                this._saxUserImage(contentHandler, authorIdentity, lang);
            }
        }
    }

    protected Map<String, Object> getCommentAuthor(Comment comment, Map<String, Object> contextualParameters) {
        Map comment2json = super.getCommentAuthor(comment, contextualParameters);
        Optional<UserIdentity> authorIdentity = this.getAuthorIdentity(comment, contextualParameters);
        if (authorIdentity.isPresent()) {
            String lang = (String)contextualParameters.get("sitemapLanguage");
            Content userContent = this._userDirectoryHelper.getUserContent(authorIdentity.get(), lang);
            if (userContent != null) {
                String organisationAccr;
                String organisation;
                String function;
                if (userContent.hasDefinition("function") && StringUtils.isNotEmpty((CharSequence)(function = (String)userContent.getValue("function", false, null)))) {
                    comment2json.put("author-function", function);
                }
                if (userContent.hasDefinition("organisation") && StringUtils.isNotEmpty((CharSequence)(organisation = (String)userContent.getValue("organisation", false, null)))) {
                    comment2json.put("author-organisation", organisation);
                }
                if (userContent.hasDefinition("organisation-accronym") && StringUtils.isNotEmpty((CharSequence)(organisationAccr = (String)userContent.getValue("organisation-accronym", false, null)))) {
                    comment2json.put("author-organisation-accronym", organisationAccr);
                }
            }
        }
        return comment2json;
    }

    protected void _saxUserImage(ContentHandler contentHandler, UserIdentity userIdentity, String language) throws SAXException {
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"author-img-url", (String)this._workspaceHelper.getAvatar(userIdentity, language, 45));
    }

    protected void _saxAdditionalUserProperties(ContentHandler contentHandler, Content userContent) throws SAXException {
        String organisationAccr;
        String organisation;
        String function;
        if (userContent.hasDefinition("function") && StringUtils.isNotEmpty((CharSequence)(function = (String)userContent.getValue("function", false, null)))) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"author-function", (String)function);
        }
        if (userContent.hasDefinition("organisation") && StringUtils.isNotEmpty((CharSequence)(organisation = (String)userContent.getValue("organisation", false, null)))) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"author-organisation", (String)organisation);
        }
        if (userContent.hasDefinition("organisation-accronym") && StringUtils.isNotEmpty((CharSequence)(organisationAccr = (String)userContent.getValue("organisation-accronym", false, null)))) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"author-organisation-accronym", (String)organisationAccr);
        }
    }

    protected Optional<UserIdentity> getAuthorIdentity(Comment comment, Map<String, Object> contextualParameters) {
        UserIdentity authorIdentity = comment.getAuthor();
        return authorIdentity != null ? Optional.of(authorIdentity) : this.getUserByEmail(comment.getAuthorEmail(), contextualParameters).map(User::getIdentity);
    }
}

