/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class DocumentWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String DOCUMENT_MODULE_ID = DocumentWorkspaceModule.class.getName();
    public static final String WORKSPACES_DOCUMENTS_NODE_NAME = "documents";
    private static final String __DOCUMENT_NUMBER_HEADER_ID = "documents$document_number";

    @Override
    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public String getId() {
        return DOCUMENT_MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return WORKSPACES_DOCUMENTS_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 20;
    }

    @Override
    protected String getModulePageName() {
        return WORKSPACES_DOCUMENTS_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_DOCUMENT_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_DOCUMENT_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_DOCUMENTS_TITLE");
    }

    @Override
    protected void initializeModulePage(ModifiablePage documentPage) {
        ModifiableZone defaultZone = documentPage.createZone("default");
        String serviceId = "org.ametys.plugins.workspaces.module.Document";
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
        defaultZoneItem.setServiceId(serviceId);
        ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
        serviceDataHolder.setValue("xslt", (Object)this._getDefaultXslt(serviceId));
    }

    public String getFolderUri(Project project, String collectionId) {
        String moduleUrl = this.getModuleUrl(project);
        if (moduleUrl != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(moduleUrl);
            sb.append("#").append(collectionId);
            return sb.toString();
        }
        return null;
    }

    @Callable(rights={"*"})
    public Map<String, Object> getModuleBaseRights() {
        Request request = ContextHelper.getRequest((Context)this._context);
        String projectName = (String)request.getAttribute("projectName");
        Project project = this._projectManager.getProject(projectName);
        ModifiableResourceCollection documentRoot = this.getModuleRoot(project, false);
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("add-file", this._rightManager.hasRight(user, "Plugin_Explorer_File_Add", (Object)documentRoot) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-folder", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Add", (Object)documentRoot) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-cmis-folder", this._rightManager.hasRight(user, "Plugin_Explorer_CMIS_Add", (Object)documentRoot) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-tag", this._projectRightHelper.canAddTag(project));
        rightsData.put("remove-tag", this._projectRightHelper.canRemoveTag(project));
        return rightsData;
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"resource.created", (Object)"resource.commented", (Object)"resource.renamed", (Object)"resource.updated");
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            ModifiableResourceCollection documentRoot = this.getModuleRoot(project, false);
            long fileNumber = documentRoot.getChildren().stream().mapToLong(child -> this._getFileNumber((AmetysObject)child)).sum();
            return Map.of(__DOCUMENT_NUMBER_HEADER_ID, fileNumber);
        }
        return Map.of(__DOCUMENT_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    private long _getRessourceSize(AmetysObject document) {
        if (document instanceof Resource) {
            Resource file = (Resource)document;
            return file.getLength();
        }
        if (document instanceof ResourceCollection) {
            ResourceCollection folder = (ResourceCollection)document;
            return folder.getChildren().stream().mapToLong(child -> this._getRessourceSize((AmetysObject)child)).sum();
        }
        return 0L;
    }

    private long _getFileNumber(AmetysObject document) {
        if (document instanceof Resource) {
            return 1L;
        }
        if (document instanceof ResourceCollection) {
            ResourceCollection folder = (ResourceCollection)document;
            return folder.getChildren().stream().mapToLong(child -> this._getFileNumber((AmetysObject)child)).sum();
        }
        return 0L;
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__DOCUMENT_NUMBER_HEADER_ID, new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_FILE_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected long _getModuleSize(Project project) {
        return this.getModuleRoot(project, false).getChildren().stream().mapToLong(child -> this._getRessourceSize((AmetysObject)child)).sum();
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }

    @Override
    public Set<String> getAllEventTypes() {
        return Set.of("resource.created", "resource.commented", "resource.deleted", "resource.moved", "resource.renamed", "resource.updated");
    }

    @Override
    public ModifiableResourceCollection getModuleRoot(Project project, boolean create) {
        try {
            ExplorerNode projectRootNode = project.getExplorerRootNode();
            if (projectRootNode instanceof ModifiableResourceCollection) {
                ModifiableResourceCollection projectRootNodeRc = (ModifiableResourceCollection)projectRootNode;
                return (ModifiableResourceCollection)this._getAmetysObject((ModifiableTraversableAmetysObject)projectRootNodeRc, this.getModuleName(), "ametys:folder", create);
            }
            throw new IllegalArgumentException("Error getting the " + this.getModuleName() + " root node : it should be a ModifiableResourceCollection and not " + String.valueOf(projectRootNode.getClass()));
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Error getting the " + this.getModuleName() + " root node.", (Throwable)e);
        }
    }
}

