/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.repository.comment.Comment;
import org.ametys.cms.repository.mentions.MentionUtils;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;
import org.ametys.plugins.workspaces.comments.CommentsDAO;
import org.ametys.plugins.workspaces.documents.DocumentsJSONHelper;
import org.ametys.plugins.workspaces.documents.jcr.File;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class WorkspaceExplorerResourceCommentsDAO
extends AbstractWorkspaceDAO {
    public static final String RIGHTS_RESOURCE_COMMENT = "Plugin_Explorer_File_Comment";
    protected DocumentsJSONHelper _documentsJSONHelper;
    protected CommentsDAO _commentsDAO;
    protected MentionUtils _mentionUtils;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._documentsJSONHelper = (DocumentsJSONHelper)((Object)manager.lookup(DocumentsJSONHelper.ROLE));
        this._commentsDAO = (CommentsDAO)((Object)manager.lookup(org.ametys.cms.repository.comment.CommentsDAO.ROLE));
        this._mentionUtils = (MentionUtils)manager.lookup(MentionUtils.ROLE);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> addComment(String resourceId, String commentText) {
        File resource = (File)this._resolver.resolveById(resourceId);
        ModifiableTraversableAmetysObject resourcesRoot = (ModifiableTraversableAmetysObject)resource.getParent();
        UserIdentity currentUser = this._currentUserProvider.getUser();
        this._checkUserRights((AmetysObject)resourcesRoot, RIGHTS_RESOURCE_COMMENT);
        Comment comment = this.createComment(resource, commentText, resourcesRoot);
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", resourceId);
        eventParams.put("fileComment", this._mentionUtils.transformTextToReadableText(commentText, null));
        eventParams.put("fileCommentId", comment.getId());
        this._observationManager.notify(new Event("resource.commented", currentUser, eventParams));
        List<Comment> comments = resource.getComments(true, true);
        return this._documentsJSONHelper.commentsToJson(comments, resourceId, resourceId);
    }

    @Callable(rights={"__READ_ACCESS"}, paramIndex=0, rightContext="right.assignment.context.resource")
    public List<Map<String, Object>> getComments(String resourceId) {
        File resource = (File)this._resolver.resolveById(resourceId);
        List<Comment> comments = resource.getComments(true, true);
        return this._documentsJSONHelper.commentsToJson(comments, resourceId, resourceId);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> editCommentResource(String resourceId, String commentId, String commentText) {
        File resource = (File)this._resolver.resolveById(resourceId);
        ModifiableTraversableAmetysObject resourcesRoot = (ModifiableTraversableAmetysObject)resource.getParent();
        this._checkUserRights((AmetysObject)resourcesRoot, RIGHTS_RESOURCE_COMMENT);
        this.editComment(resource, commentId, commentText, resourcesRoot);
        List<Comment> comments = resource.getComments(true, true);
        return this._documentsJSONHelper.commentsToJson(comments, resourceId, resourceId);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> answerCommentResource(String resourceId, String commentId, String commentText) {
        File resource = (File)this._resolver.resolveById(resourceId);
        ModifiableTraversableAmetysObject resourcesRoot = (ModifiableTraversableAmetysObject)resource.getParent();
        this._checkUserRights((AmetysObject)resourcesRoot, RIGHTS_RESOURCE_COMMENT);
        this.answerComment(resource, commentId, commentText, resourcesRoot);
        List<Comment> comments = resource.getComments(true, true);
        return this._documentsJSONHelper.commentsToJson(comments, resourceId, resourceId);
    }
}

