/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.content.indexing.solr.SolrResourceGroupedMimeTypes;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetFileIconAction
extends ServiceableAction {
    protected static final String[] ARCHIVE_MIMETYPE = new String[]{"application/x-rar-compressed", "application/octet-stream", "application/zip", "application/x-zip", "application/octet-stream", "application/x-zip-compressed", "multipart/x-zip", "application/tar", "application/x-tar", "application/x-gtar", "multipart/x-tar", "application/x-compress", "application/x-compressed", "application/gzip", "application/x-gzip", "application/x-gtar", "application/x-tgz"};

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String mimeType = request.getParameter("mimeType");
        if (Arrays.asList(ARCHIVE_MIMETYPE).contains(mimeType)) {
            result.put("type", "archive");
        } else {
            Optional group = SolrResourceGroupedMimeTypes.getGroup((String)mimeType);
            WorkspacesHelper.FileType type = group.map(groupMimeType -> WorkspacesHelper.FileType.valueOf(groupMimeType.toUpperCase())).orElse(WorkspacesHelper.FileType.UNKNOWN);
            result.put("type", type.name().toLowerCase());
        }
        return result;
    }
}

