/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadUserPreferencesDAO;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public abstract class AbstractWorkspaceThreadDAO
extends AbstractWorkspaceDAO {
    protected ThreadJSONHelper _threadJSONHelper;
    protected WorkspaceThreadUserPreferencesDAO _workspaceThreadUserPrefDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)manager.lookup(ThreadJSONHelper.ROLE));
        this._workspaceThreadUserPrefDAO = (WorkspaceThreadUserPreferencesDAO)((Object)manager.lookup(WorkspaceThreadUserPreferencesDAO.ROLE));
    }

    protected ModifiableTraversableAmetysObject _getThreadRoot(Project project) {
        ForumWorkspaceModule threadModule = (ForumWorkspaceModule)this._workspaceModuleEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        return threadModule.getModuleRoot(project, true);
    }

    protected ModifiableResourceCollection _getModuleRoot() {
        String projectName = this.getProjectName();
        return this._getModuleRoot(projectName);
    }

    protected ModifiableResourceCollection _getModuleRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        ForumWorkspaceModule forumModule = (ForumWorkspaceModule)this._workspaceModuleEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        return forumModule.getModuleRoot(project, false);
    }

    protected void _checkUserRights(AmetysObject objectToCheck, String superRightId, Thread thread, String authorRightId) {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, superRightId, (Object)objectToCheck) == RightManager.RightResult.RIGHT_ALLOW) {
            return;
        }
        if (this._rightManager.hasRight(user, authorRightId, (Object)objectToCheck) == RightManager.RightResult.RIGHT_ALLOW && thread.getAuthor().equals((Object)user)) {
            return;
        }
        throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to perform operation without convenient right");
    }
}

