/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.initialization;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.filereloader.FileReloader;
import org.ametys.core.util.filereloader.FileReloaderUtils;
import org.ametys.plugins.workspaces.PagePopulator;
import org.ametys.plugins.workspaces.initialization.PageInitializer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class DefaultStaticPageInitializer
extends AbstractLogEnabled
implements PageInitializer,
Configurable,
Serviceable {
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    private PagePopulator _pagePopulator;
    private Map<String, Configuration> _pageModels = new HashMap<String, Configuration>();
    private int _priority;
    private String _path;
    private FileReloaderUtils _fileReloader;

    public void configure(Configuration configuration) throws ConfigurationException {
        this._path = configuration.getChild("model").getAttribute("path");
        this._priority = configuration.getChild("priority", true).getValueAsInteger(100);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._pagePopulator = (PagePopulator)((Object)manager.lookup(PagePopulator.ROLE));
        this._fileReloader = (FileReloaderUtils)manager.lookup(FileReloaderUtils.ROLE);
    }

    public int getPriority() {
        return this._priority;
    }

    @Override
    public Optional<? extends Page> createPage(ModifiableSitemapElement parent) {
        Configuration model = this._loadPageModel(parent.getSite().getSkinId());
        if (model != null) {
            try {
                return this._pagePopulator.initPage(parent, model);
            }
            catch (ConfigurationException e) {
                this.getLogger().error("An error occurred during the page initialization because the configuration was invalid.", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error("An unexpected error occurred during the page initialization.", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private Configuration _loadPageModel(String skinId) {
        try {
            String skinPath = StringUtils.replace((String)this._path, (String)"{skinId}", (String)skinId);
            this._fileReloader.updateFile(skinPath, (FileReloader)new PageModelReloader(skinPath, this));
            return this._pageModels.get(skinPath);
        }
        catch (Exception e) {
            throw new IllegalStateException("No configuration found at path '" + this._path + "' for skin '" + skinId + "'.", e);
        }
    }

    public void setModel(String path, Configuration cfg) {
        this._pageModels.put(path, cfg);
    }

    protected record PageModelReloader(String path, DefaultStaticPageInitializer initializer) implements FileReloader
    {
        public void updateFile(String sourceUrl, Source source, InputStream is) throws Exception {
            if (is != null) {
                this.initializer.setModel(this.path, new DefaultConfigurationBuilder().build(is, source.getURI()));
            }
        }

        public String getId(String sourceUrl) {
            return PageModelReloader.class.getName() + "#" + this.path;
        }
    }
}

