/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.initialization;

import java.util.HashMap;
import java.util.Optional;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workspaces.initialization.DefaultStaticPageInitializer;
import org.ametys.web.repository.page.ModifiableSitemapElement;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.StringUtils;

public class ProjectsCatalogPageInitializer
extends DefaultStaticPageInitializer {
    @Override
    public Optional<? extends Page> createPage(ModifiableSitemapElement parent) {
        Page page;
        Optional<? extends Page> result = super.createPage(parent);
        if (result.isPresent() && (page = result.get()) instanceof ModifiableSitemapElement) {
            ModifiableSitemapElement page2 = (ModifiableSitemapElement)page;
            try (AmetysObjectIterable zones = page2.getZones();){
                for (ModifiableZone zone : zones) {
                    AmetysObjectIterable zoneItems = zone.getZoneItems();
                    try {
                        for (ModifiableZoneItem zoneItem : zoneItems) {
                            if (!StringUtils.equals((CharSequence)zoneItem.getServiceId(), (CharSequence)"org.ametys.plugins.workspaces.service.ProjectsCatalogue")) continue;
                            ModifiableModelAwareDataHolder serviceParameters = zoneItem.getServiceParameters();
                            try (AmetysObjectIterable sitemaps = page2.getSite().getSitemaps();){
                                serviceParameters.setValue("availableLanguages", sitemaps.stream().map(SimpleAmetysObject::getName).toArray(String[]::new));
                            }
                            zoneItem.saveChanges();
                            HashMap<String, Object> eventParams = new HashMap<String, Object>();
                            eventParams.put("zone.item", zoneItem);
                            eventParams.put("zone.item.id", zoneItem.getId());
                            eventParams.put("zone.item.service", zoneItem.getServiceId());
                            this._observationManager.notify(new Event("service.modified", this._currentUserProvider.getUser(), eventParams));
                        }
                    }
                    finally {
                        if (zoneItems == null) continue;
                        zoneItems.close();
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().error("An unexpected error occurred during the page initialization.", (Throwable)e);
            }
        }
        return result;
    }
}

