/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.tag.AbstractTagProvider;
import org.ametys.cms.tag.CMSTag;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.TagTargetType;
import org.ametys.cms.tag.TagTargetTypeExtensionPoint;
import org.ametys.plugins.workspaces.keywords.KeywordCMSTag;
import org.ametys.plugins.workspaces.keywords.KeywordJCRProvider;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class KeywordTagProvider
extends AbstractTagProvider<CMSTag>
implements Serviceable {
    protected TagTargetTypeExtensionPoint _targetTypeEP;
    protected KeywordProviderExtensionPoint _keywordProviderEP;
    protected KeywordJCRProvider _jcrKeywordProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._targetTypeEP = (TagTargetTypeExtensionPoint)smanager.lookup(TagTargetTypeExtensionPoint.ROLE);
        this._keywordProviderEP = (KeywordProviderExtensionPoint)((Object)smanager.lookup(KeywordProviderExtensionPoint.ROLE));
        this._jcrKeywordProvider = (KeywordJCRProvider)((Object)this._keywordProviderEP.getExtension(KeywordJCRProvider.class.getName()));
    }

    public Map<String, CMSTag> getTags(Map<String, Object> contextualParameters) {
        HashMap<String, CMSTag> cmsTags = new HashMap<String, CMSTag>();
        Map keywords = this._jcrKeywordProvider.getTags(contextualParameters);
        for (Map.Entry category : keywords.entrySet()) {
            KeywordCMSTag keywordTag = this._transformToCMSTag((DefaultTag)category.getValue(), contextualParameters);
            cmsTags.put(keywordTag.getId(), this._transformToCMSTag((DefaultTag)category.getValue(), contextualParameters));
        }
        return cmsTags;
    }

    public CMSTag getTag(String tagName, Map<String, Object> contextualParameters) {
        String keywordName = tagName;
        if (keywordName.startsWith("WORKSPACES_KEYWORD_")) {
            keywordName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_KEYWORD_");
            return this._transformToCMSTag((DefaultTag)this._jcrKeywordProvider.getTag(keywordName, contextualParameters), contextualParameters);
        }
        return null;
    }

    public Collection<CMSTag> getTags(String tagName, Map<String, Object> contextualParameters) {
        String keywordName = tagName;
        if (keywordName.startsWith("WORKSPACES_KEYWORD_")) {
            keywordName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_KEYWORD_");
            Collection<DefaultTag> keywords = this._jcrKeywordProvider.getTags(keywordName, contextualParameters);
            return keywords.stream().map(tag -> this._transformToCMSTag((DefaultTag)tag, contextualParameters)).collect(Collectors.toList());
        }
        return List.of();
    }

    public boolean hasTag(String tagName, Map<String, Object> contextualParameters) {
        String keywordName = tagName;
        if (keywordName.startsWith("WORKSPACES_KEYWORD_")) {
            keywordName = StringUtils.substringAfter((String)tagName, (String)"WORKSPACES_KEYWORD_");
            return this._jcrKeywordProvider.hasTag(keywordName, contextualParameters);
        }
        return false;
    }

    protected KeywordCMSTag _transformToCMSTag(DefaultTag keyword, Map<String, Object> contextualParameters) {
        if (keyword != null) {
            CMSTag parentTag = null;
            DefaultTag parentKeyword = keyword.getParent();
            if (parentKeyword != null) {
                parentTag = this.getTag(parentKeyword.getName(), contextualParameters);
            }
            TagTargetType targetType = this._targetTypeEP.getTagTargetType("CONTENT");
            return new KeywordCMSTag(keyword, parentTag, targetType);
        }
        return null;
    }
}

