/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.minisite;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.minisite.AbstractConvertMinisiteEventObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ConvertPageEvent2MinisitePageEventObserver
extends AbstractConvertMinisiteEventObserver {
    protected static final Map<String, String> _EVENTS_ID_CONVERSION = Map.of("page.added", "minisite.page.created", "page.updated", "minisite.page.updated", "page.renamed", "minisite.page.renamed", "page.deleting", "minisite.page.deleted");
    private AmetysObjectResolver _resolver;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        String eventId = event.getId();
        return _EVENTS_ID_CONVERSION.containsKey(eventId);
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Project project;
        Page page = (Page)event.getArguments().get("page");
        if (page == null) {
            String pageId = (String)event.getArguments().get("page.id");
            page = (Page)this._resolver.resolveById(pageId);
        }
        if ((project = this._getProject(page)) != null && this.isMinisitePage(project, (SitemapElement)page)) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>(event.getArguments());
            eventParams.put("project", (Object)project);
            if (event.getId().equals("page.deleting")) {
                eventParams.remove("page");
                eventParams.put("page.id", page.getId());
                eventParams.put("minisite.page.title", page.getTitle());
            }
            this._observationManager.notify(new Event(_EVENTS_ID_CONVERSION.get(event.getId()), event.getIssuer(), eventParams));
        }
    }

    protected Project _getProject(Page page) {
        Site site = page.getSite();
        List<Project> projectsForSite = this._projectManager.getProjectsForSite(site);
        if (!projectsForSite.isEmpty()) {
            return projectsForSite.get(0);
        }
        return null;
    }
}

