/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.minisite;

import com.google.common.collect.ImmutableSet;
import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.Resource;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableWorkflowAwareContent;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.Query;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.search.query.SiteQuery;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class MiniSiteWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String MINISITE_MODULE_ID = MiniSiteWorkspaceModule.class.getName();
    private static final String __WORKSPACES_MINISITE_NODE_NAME = "minisite";
    private static final int __INITIAL_WORKFLOW_ACTION_ID = 13;
    private static final String __ARTICLE_NUMBER_HEADER_ID = "minisite$article_number";
    protected WorkflowProvider _workflowProvider;
    protected ContentSearcherFactory _contentSearcherFactory;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._contentSearcherFactory = (ContentSearcherFactory)manager.lookup(ContentSearcherFactory.ROLE);
    }

    @Override
    public String getId() {
        return MINISITE_MODULE_ID;
    }

    @Override
    public boolean isUnactivatedByDefault() {
        return true;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_MINISITE_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 60;
    }

    @Override
    protected String getModulePageName() {
        return __WORKSPACES_MINISITE_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_MINISITE_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_MINISITE_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_MINISITE_TITLE");
    }

    protected String getFirstSectionName() {
        return "section";
    }

    protected I18nizableText getFirstSectionTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_MINISITE_FIRST_SECTION_TITLE");
    }

    @Override
    protected String getModulePageTemplate() {
        return null;
    }

    @Override
    protected void initializeModulePage(ModifiablePage modulePage) {
        modulePage.untag("SECTION");
        ModifiablePage firstSection = this._createAndInitializeFirstSectionPage(modulePage, this.getFirstSectionName(), this.getFirstSectionTitle());
        if (firstSection != null) {
            this._initializeFirstSectionDefaultZone(firstSection);
        }
    }

    protected ModifiablePage _createAndInitializeFirstSectionPage(ModifiablePage modulePage, String name, I18nizableText pageTitle) {
        if (!modulePage.hasChild(name)) {
            ModifiablePage page = (ModifiablePage)modulePage.createChild(name, "ametys:defaultPage");
            page.setTitle((String)StringUtils.defaultIfEmpty((CharSequence)this._i18nUtils.translate((I18nizable)pageTitle, modulePage.getSitemapName()), (CharSequence)"Missing title"));
            page.setType(Page.PageType.CONTAINER);
            page.setSiteName(modulePage.getSiteName());
            page.setSitemapName(modulePage.getSitemapName());
            page.setTemplate("project-minisite");
            page.tag("SECTION");
            page.saveChanges();
            HashMap<String, ModifiablePage> eventParams = new HashMap<String, ModifiablePage>();
            eventParams.put("page", page);
            this._observationManager.notify(new Event("page.added", this._currentUserProvider.getUser(), eventParams));
            return page;
        }
        return null;
    }

    protected void _initializeFirstSectionDefaultZone(ModifiablePage page) {
        ModifiableZone defaultZone = page.createZone("default");
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.CONTENT);
        try {
            ModifiableWorkflowAwareContent content = this._createDefaultContent(page.getSite(), page.getSitemapName(), page.getTitle());
            defaultZoneItem.setContent((Content)content);
            content.saveChanges();
        }
        catch (WorkflowException e) {
            this.getLogger().error("Unable to initialize the first page for minisite module, the page will not be editable until the content is manually created in the BackOffice", (Throwable)e);
        }
    }

    protected ModifiableWorkflowAwareContent _createDefaultContent(Site site, String sitemapName, String title) throws WorkflowException {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TITLE_KEY, title);
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_NAME_KEY, NameHelper.filterName((String)title));
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TYPES_KEY, new String[]{"org.ametys.plugins.workspaces.Content.projectArticle"});
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_LANGUAGE_KEY, sitemapName);
        inputs.put(CreateContentFunction.SITE_KEY, site.getName());
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
        workflow.initialize("workspaces-content", 13, inputs);
        Map results = (Map)inputs.get(AbstractWorkflowComponent.RESULT_MAP_KEY);
        ModifiableWorkflowAwareContent content = (ModifiableWorkflowAwareContent)results.get(Content.class.getName());
        return content;
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"minisite.page.created", (Object)"minisite.page.updated", (Object)"minisite.page.renamed", (Object)"minisite.page.deleted");
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            HashMap<String, Object> statistics = new HashMap<String, Object>();
            try {
                AmetysObjectIterable results = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectArticle"}).search((Query)new SiteQuery(new String[]{project.getName()}));
                statistics.put(__ARTICLE_NUMBER_HEADER_ID, results.getSize());
            }
            catch (Exception e) {
                this.getLogger().error("Error searching wall content in project " + project.getId(), (Throwable)e);
            }
            return statistics;
        }
        return Map.of(__ARTICLE_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__ARTICLE_NUMBER_HEADER_ID, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_MINISITE_ARTICLE_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected long _getModuleSize(Project project) {
        try {
            AmetysObjectIterable resultsIterable = this._contentSearcherFactory.create(new String[]{"org.ametys.plugins.workspaces.Content.projectArticle"}).search((Query)new SiteQuery(new String[]{project.getName()}));
            return resultsIterable.stream().map(content -> content.getValue("illustration/image")).filter(Objects::nonNull).filter(Binary.class::isInstance).map(Binary.class::cast).mapToLong(Resource::getLength).sum();
        }
        catch (Exception e) {
            this.getLogger().error("Error searching minisite content images in project " + project.getId(), (Throwable)e);
            return __SIZE_ERROR;
        }
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }
}

