/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import java.util.List;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.plugins.core.ui.glyph.CssFontHelper;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProjectsCalendarGenerator
extends ServiceableGenerator
implements Contextualizable {
    private SourceResolver _sourceResolver;
    private Context _context;
    private SiteManager _siteManager;
    private ProjectManager _projectManager;
    private WorkspaceModuleExtensionPoint _workspaceModuleEP;
    private CssFontHelper _cssFontHelper;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sourceResolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._siteManager = (SiteManager)this.manager.lookup(SiteManager.ROLE);
        this._projectManager = (ProjectManager)((Object)this.manager.lookup(ProjectManager.ROLE));
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)this.manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._cssFontHelper = (CssFontHelper)this.manager.lookup(CssFontHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"calendar");
        this._saxColors();
        this._saxAllColors();
        this._saxResourceCalendar();
        this._saxRecurrenceTypes();
        this._saxGlyphs();
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"calendar");
        this.contentHandler.endDocument();
    }

    private void _saxColors() throws SAXException, MalformedURLException, IOException, ProcessingException {
        Source calendarColors = null;
        try {
            calendarColors = this._sourceResolver.resolveURI("plugin:workspaces://calendar-colors.xml");
            if (calendarColors.exists()) {
                SourceUtil.toSAX((Source)calendarColors, (ContentHandler)new IgnoreRootHandler(this.contentHandler));
            }
        }
        catch (SourceNotFoundException sourceNotFoundException) {
        }
        finally {
            this._sourceResolver.release(calendarColors);
        }
    }

    private void _saxAllColors() throws SAXException, MalformedURLException, IOException, ProcessingException {
        Source calendarColors = null;
        try {
            calendarColors = this._sourceResolver.resolveURI("plugin:workspaces://source-calendar-colors.xml");
            if (calendarColors.exists()) {
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"allColors");
                SourceUtil.toSAX((Source)calendarColors, (ContentHandler)new IgnoreRootHandler(this.contentHandler));
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"allColors");
            }
        }
        catch (SourceNotFoundException sourceNotFoundException) {
        }
        finally {
            this._sourceResolver.release(calendarColors);
        }
    }

    private void _saxResourceCalendar() throws SAXException {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Calendar calendar = calendarModule.getResourceCalendar(this._getProject());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"resourceCalendar");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"id", (String)calendar.getId());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)calendar.getName());
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"color", (String)calendar.getColor());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"resourceCalendar");
    }

    private Project _getProject() {
        Project project = null;
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = (String)request.getAttribute("site");
        if (StringUtils.isNotEmpty((CharSequence)siteName) && this._siteManager.hasSite(siteName)) {
            Site site = this._siteManager.getSite(siteName);
            List<Project> projects = this._projectManager.getProjectsForSite(site);
            project = !projects.isEmpty() ? projects.get(0) : null;
        }
        return project;
    }

    private void _saxRecurrenceTypes() throws SAXException {
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"recurrenceTypes");
        for (EventRecurrenceTypeEnum eventRecurrenceTypeEnum : EventRecurrenceTypeEnum.values()) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"recurrenceType");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"recurrenceTypeName", (String)eventRecurrenceTypeEnum.name());
            new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_EVENT_LIST_PERIOD_" + eventRecurrenceTypeEnum.name()).toSAX(this.contentHandler, "recurrenceTypeLabel");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"recurrenceType");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"recurrenceTypes");
    }

    private void _saxGlyphs() throws SAXException {
        LinkedHashSet glyphs = new LinkedHashSet();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"glyphs");
        boolean havePremium = PluginsManager.getInstance().getPluginNames().contains("fontawesome");
        String cssUri = "plugin:fontawesome6" + (havePremium ? "" : "-free") + "://resources/css/";
        glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssUri + "ametys-solid.css", null));
        glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssUri + "ametys-brands.css", null));
        if (havePremium) {
            glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssUri + "ametys-light.css", null));
        }
        glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssUri + "ametys-regular.css", null));
        for (List similairGlyphs : glyphs) {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"glyph");
            for (String glyph : similairGlyphs) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"alt", (String)glyph);
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"glyph");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"glyphs");
    }
}

