/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.generators;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ametys.cms.tag.AbstractTagProviderExtensionPoint;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.workspaces.categories.Category;
import org.ametys.plugins.workspaces.categories.CategoryHelper;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadDAO;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SimpleProjectsCatalogueGenerator
extends ServiceableGenerator {
    private ProjectManager _projectManager;
    private ProjectMemberManager _projectMemberManager;
    private UserManager _userManager;
    private CurrentUserProvider _currentUserProvider;
    private UserHelper _userHelper;
    private WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    private WorkspaceTaskDAO _workspaceTaskDAO;
    private WorkspaceThreadDAO _workspaceThreadDAO;
    private CategoryProviderExtensionPoint _categoryProviderEP;
    private ProjectTagProviderExtensionPoint _projectTagProviderEP;
    private CategoryHelper _categoryHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._projectManager = (ProjectManager)((Object)serviceManager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)serviceManager.lookup(ProjectMemberManager.ROLE));
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO)((Object)serviceManager.lookup(WorkspaceExplorerResourceDAO.ROLE));
        this._workspaceTaskDAO = (WorkspaceTaskDAO)((Object)serviceManager.lookup(WorkspaceTaskDAO.ROLE));
        this._workspaceThreadDAO = (WorkspaceThreadDAO)((Object)serviceManager.lookup(WorkspaceThreadDAO.ROLE));
        this._projectTagProviderEP = (ProjectTagProviderExtensionPoint)((Object)this.manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._categoryProviderEP = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._categoryHelper = (CategoryHelper)serviceManager.lookup(CategoryHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        int max = this.parameters.getParameterAsInteger("max-results", 0);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ZoneItem zoneItem = (ZoneItem)request.getAttribute(WebConstants.REQUEST_ATTR_ZONEITEM);
        boolean memberOnly = (Boolean)zoneItem.getServiceParameters().getValue("memberOnly", false, (Object)false);
        String[] filterCategoriesArray = (String[])zoneItem.getServiceParameters().getValue("filterCategories", false, (Object)new String[0]);
        Set<String> filterCategories = Set.of(filterCategoriesArray);
        this.contentHandler.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("zoneItemId", zoneItem.getId());
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"projects", (Attributes)attrs);
        if (this._currentUserProvider.getUser() != null) {
            Function<Project, String> getProjectTitle = Project::getTitle;
            Comparator<Project> projectTitleComparator = Comparator.comparing(getProjectTitle.andThen(StringUtils::stripAccents), String.CASE_INSENSITIVE_ORDER);
            Stream<Project> projectStream = memberOnly ? this._projectManager.getUserProjects(this._currentUserProvider.getUser(), filterCategories).keySet().stream().sorted(projectTitleComparator) : this._projectManager.getProjects(filterCategories).stream().filter(project -> !project.getInscriptionStatus().equals((Object)Project.InscriptionStatus.PRIVATE) || this._projectMemberManager.isProjectMember((Project)((Object)project), this._currentUserProvider.getUser())).sorted(projectTitleComparator);
            if (max > 0) {
                projectStream = projectStream.limit(max);
            }
            projectStream.forEach(p -> this._saxProject((Project)((Object)p)));
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"projects");
        this.contentHandler.endDocument();
    }

    private void _saxProject(Project project) {
        try {
            Site site = project.getSite();
            if (site == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(String.format("The project '%s' does not have any associated site.", project.getTitle()));
                }
                return;
            }
            UserIdentity userIdentity = this._currentUserProvider.getUser();
            boolean hasAccess = this._projectMemberManager.isProjectMember(project, userIdentity);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", project.getId());
            attrs.addCDATAAttribute("name", project.getName());
            attrs.addCDATAAttribute("siteName", site.getName());
            attrs.addCDATAAttribute("hasAccess", Boolean.toString(hasAccess));
            Project.InscriptionStatus inscriptionStatus = project.getInscriptionStatus();
            attrs.addCDATAAttribute("inscriptionStatus", inscriptionStatus.toString());
            if (!hasAccess && !inscriptionStatus.equals((Object)Project.InscriptionStatus.PRIVATE) && userIdentity != null) {
                attrs.addCDATAAttribute("inPopulations", Boolean.toString(this._projectManager.isUserInProjectPopulations(project, userIdentity)));
            }
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"project", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"title", (String)project.getTitle());
            String siteUrl = site.getUrl();
            if (siteUrl != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"url", (String)site.getUrl());
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)StringUtils.defaultString((String)project.getDescription()));
            site.illustrationToSAX(this.contentHandler);
            project.coverImageToSAX(this.contentHandler);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"managers");
            Arrays.stream(project.getManagers()).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).forEach(LambdaUtils.wrapConsumer(m -> this._userHelper.saxUser(m, this.contentHandler, "manager")));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"managers");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"projectTags");
            project.getTags().stream().forEach(this._saxDefaultTag(this._projectTagProviderEP, "projectTag"));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"projectTags");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"keywords");
            Arrays.stream(project.getKeywords()).forEach(LambdaUtils.wrapConsumer(keyword -> XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"keyword", (String)keyword)));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"keywords");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"categories");
            project.getCategories().stream().forEach(this._saxCategory("category"));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"categories");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"statistics");
            this._saxProjectStatistic("nbProjectMember", this._projectMemberManager.getMembersCount(project));
            this._saxProjectStatistic("nbProjectDocuments", this._workspaceExplorerResourceDAO.getDocumentsCount(project));
            this._saxProjectStatistic("nbProjectTasks", this._workspaceTaskDAO.getTasksCount(project));
            this._saxProjectStatistic("nbProjectThreads", this._workspaceThreadDAO.getThreadsCount(project));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"statistics");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"project");
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(String.format("Unable to SAX project with id '%s'", project.getId()), e);
        }
    }

    private Consumer<String> _saxCategory(String tagName) {
        HashMap contextualParameter = new HashMap();
        Function<String, Function> getTagFromExtension = categoryId -> extension -> (Category)extension.getTag(categoryId, contextualParameter);
        Consumer saxCategory = LambdaUtils.wrapConsumer(category -> {
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)tagName);
            category.getTitle().toSAX(this.contentHandler, "title");
            this._saxCategoryColor((Category)category);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)tagName);
        });
        return categoryId -> this._categoryProviderEP.getExtensionsIds().stream().map(arg_0 -> ((CategoryProviderExtensionPoint)this._categoryProviderEP).getExtension(arg_0)).map((Function)getTagFromExtension.apply((String)categoryId)).filter(Objects::nonNull).findFirst().ifPresent(saxCategory);
    }

    private Consumer<String> _saxDefaultTag(AbstractTagProviderExtensionPoint<DefaultTag> provider, String tagName) {
        HashMap contextualParameter = new HashMap();
        Function<String, Function> getTagFromExtension = keywordId -> extension -> (DefaultTag)extension.getTag(keywordId, contextualParameter);
        Consumer saxTag = LambdaUtils.wrapConsumer(tag -> tag.getTitle().toSAX(this.contentHandler, tagName));
        return keywordId -> provider.getExtensionsIds().stream().map(arg_0 -> ((AbstractTagProviderExtensionPoint)provider).getExtension(arg_0)).map((Function)getTagFromExtension.apply((String)keywordId)).filter(Objects::nonNull).findFirst().ifPresent(saxTag);
    }

    private void _saxProjectStatistic(String elementName, Long count) {
        LambdaUtils.ThrowingConsumer saxElement = value -> XMLUtils.createElement((ContentHandler)this.contentHandler, (String)elementName, (String)Long.toString(value));
        Optional.ofNullable(count).ifPresent(LambdaUtils.wrapConsumer((LambdaUtils.ThrowingConsumer)saxElement));
    }

    private void _saxCategoryColor(Category category) throws SAXException {
        Map<String, String> colors = this._categoryHelper.getCategoryColor(category);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"color");
        colors.entrySet().stream().forEach(LambdaUtils.wrapConsumer(entry -> XMLUtils.createElement((ContentHandler)this.contentHandler, (String)((String)entry.getKey()), (String)((String)entry.getValue()))));
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"color");
    }
}

